import * as http from "http";
import { fromQueryString } from "../utils/conversions.js";
export class Rest {
    // A Restful API to facilitate pingback requests.
    _pingback;
    constructor(pingback) {
        // Check to make  sure we're on Node.
        if (typeof process === "undefined") {
            throw new Error("The Rest & Pingback API is only available on NodeJS");
        }
        this._pingback = pingback;
    }
    async handleRequest(req, res) {
        return new Promise((resolve) => {
            if (req.url === "/2captcha.txt") {
                res.writeHead(200);
                res.end(this._pingback.serverToken);
            }
            else if (req.url === "/pingback") {
                // Retrieve the query parameters.
                const q = fromQueryString(req.url.split("?")[1]);
                this._pingback.emit("solve", q);
            }
            else {
                res.writeHead(404);
                res.end();
            }
            return resolve();
        });
    }
    listen(port) {
        return new Promise(async (resolve) => {
            // Listen for incoming requests.
            http.createServer((req, res) => {
                this.handleRequest(req, res);
            }).listen(port, () => {
                return resolve();
            });
        });
    }
}
