import fs from 'fs'; // Importe o módulo 'fs' para ler o certificado SSL
import { exec } from 'child_process';

const accountsFilePath = 'C:\\xampp\\htdocs\\account\\accounts.json'; // Caminho para o arquivo accounts.json

// Função para ler o arquivo accounts.json
function readAccountsFile() {
    return new Promise((resolve, reject) => {
        fs.readFile(accountsFilePath, 'utf8', (err, data) => {
            if (err) {
                reject(err);
            } else {
                try {
                    resolve(JSON.parse(data));
                } catch (error) {
                    reject(error);
                }
            }
        });
    });
}

// Função para escrever no arquivo accounts.json
function writeAccountsFile(data) {
    return new Promise((resolve, reject) => {
        fs.writeFile(accountsFilePath, JSON.stringify(data, null, 4), 'utf8', (err) => {
            if (err) {
                reject(err);
            } else {
                resolve();
            }
        });
    });
}

function executePythonScript() {
    exec(`python C:\\Users\\Administrator\\Desktop\\Arthur-KingBuscas\\src\\api\\maxbuscas\\logout.py`, (error, stdout, stderr) => {
        if (error) {
            console.error(`Erro ao executar o script Python local: ${error.message}`);
            return res.status(500).json({ error: 'Erro interno do servidor' });
        }
        if (stderr) {
            console.error(`Erro de script Python local: ${stderr}`);
            return res.status(500).json({ error: 'Erro interno do servidor' });
        }
    })
}


let currentAccountIndex = 0; // Índice para controlar qual conta está sendo processada atualmente

export async function decrementAndReorderConsults() {
    try {
        let database = await readAccountsFile();

        // Encontrar a primeira conta ativa com a menor quantidade de consultas a partir de currentAccountIndex
        let activeUsers = database.users.filter(user => user.status === 'active');

        if (activeUsers.length === 0) {
            console.log('Nenhum usuário ativo encontrado.');
            return;
        }

        let minConsultas = Number.MAX_SAFE_INTEGER;
        let userToDecrement = null;
        let indexOfMinConsultas = -1;

        // Encontrar a conta ativa com a menor quantidade de consultas a partir de currentAccountIndex
        for (let i = currentAccountIndex; i < activeUsers.length; i++) {
            if (activeUsers[i].consultas < minConsultas) {
                minConsultas = activeUsers[i].consultas;
                userToDecrement = activeUsers[i];
                indexOfMinConsultas = i; // Guarda o índice da conta com menos consultas
                break; // Para no primeiro encontrado com a menor quantidade de consultas
            }
        }

        if (!userToDecrement) {
            console.log('Nenhuma conta ativa encontrada com consultas para decrementar.');
            return;
        }

        // Decrementar as consultas da conta atual
        userToDecrement.consultas--;

        // Atualizar o arquivo accounts.json com as consultas decrementadas
        await writeAccountsFile(database);

        console.log(`Consultas decrementadas com sucesso para o usuário ${userToDecrement.email}.`);

        // Se as consultas da conta atual chegaram a zero, reorganizar a lista
        if (userToDecrement.consultas === 0) {
            executePythonScript()
            console.log('Conta com 0 consultas, reorganizando lista...');

            // Mover a conta com 0 consultas para o final da lista
            database.users.push(database.users.splice(indexOfMinConsultas, 1)[0]);

            // Atualizar o arquivo accounts.json com a lista reorganizada
            await writeAccountsFile(database);

            console.log(`Lista reordenada com sucesso, movendo conta ${userToDecrement.email} para o final.`);

            // Atualizar currentAccountIndex para a próxima conta ativa com menos consultas
            currentAccountIndex++;
        }
    } catch (err) {
        console.error('Erro ao processar o arquivo accounts.json:', err);
    }
}

// Exemplo de uso: chamada da função para decrementar consultas e reordenar a lista
// decrementAndReorderConsults();
