import time
import re
import sys
import pygetwindow as gw
import pyautogui
from pywinauto import mouse
import requests
import json
import pyperclip
from bs4 import BeautifulSoup

pyautogui.FAILSAFE = False

# Receber o CPF como argumento da linha de comando
cpf = sys.argv[1] if len(sys.argv) > 1 else None

if cpf is None:
    print("Por favor, forneça o CPF como argumento da linha de comando.")
    sys.exit(1)

# Iniciar o cronômetro
# start_time = time.time()

# # Encontrar a janela do Chrome
# chrome_window = gw.getWindowsWithTitle("Google Chrome")[0]
# # Ativar o foco na janela do Chrome

# # Simular as teclas de atalho para abrir uma nova guia
# pyautogui.hotkey('ctrl', 't')
# time.sleep(1)

# Simular a digitação da URL na barra de endereço do Chrome
# pyautogui.write("https://maxbuscas.info/bases/38", interval=0.05)
# pyautogui.press('enter')
# time.sleep(1.5)

# Ativar a janela do Chrome
# chrome_window.activate()
cpfx_consulta, cpfy_consulta = 819, 361
mouse.click(coords=(cpfx_consulta, cpfy_consulta))
mouse.click(coords=(cpfx_consulta, cpfy_consulta))
time.sleep(1)
# Simular a digitação do CPF
pyautogui.write(cpf)
time.sleep(2)

# Localizar e clicar no botão de verificação do captcha
# x_captcha, y_captcha = 796, 423
# mouse.click(coords=(x_captcha, y_captcha))

# VERIFICAÇÃO DO CAPTCHA COM AS DUAS API (CAPSOLVER & TWOCAPTCHA)
time.sleep(30)

# Localizar e clicar no botão de consulta
x_consulta, y_consulta = 809, 590
x2_consulta, y2_consulta = 817, 609
mouse.click(coords=(x_consulta, y_consulta))
mouse.click(coords=(x2_consulta, y2_consulta))
time.sleep(5)

# Pressiona a combinação de teclas para selecionar todo o texto no console do DevTools (Ctrl + A)
pyautogui.hotkey('ctrl', 'shift', 'i')
time.sleep(2)
cordenadas_subindo = (1358, 582)
coordenadas_botao_showmore = (1217, 555)
coordenadas_botao_showmore2 = (1217, 559)
coordenadas_botao_showmore3 = (1217, 577)
coordenadas_botao_showmore4 = (1217, 582)
coordenadas_botao_showmore5 = (1217, 585)
coordenadas_botao_showmore6 = (1154, 593)
coordenadas_botao_showmore7 = (1154, 600)
coordenadas_botao_showmore8 = (1154, 610)
coordenadas_botao_showmore9 = (1154, 615)
coordenadas_botao_showmore10 = (1154, 620)
coordenadas_botao_selecionar = (1261, 602)
pyautogui.click(cordenadas_subindo)
pyautogui.click(*coordenadas_botao_showmore)
pyautogui.click(*coordenadas_botao_showmore2)
pyautogui.click(*coordenadas_botao_showmore3)
pyautogui.click(*coordenadas_botao_showmore4)
pyautogui.click(*coordenadas_botao_showmore5)
pyautogui.click(*coordenadas_botao_showmore6)
pyautogui.click(*coordenadas_botao_showmore7)
pyautogui.click(*coordenadas_botao_showmore8)
pyautogui.click(*coordenadas_botao_showmore9)
pyautogui.click(*coordenadas_botao_showmore10)
pyautogui.click(*coordenadas_botao_selecionar)
pyautogui.hotkey('ctrl', 'a')

# Copia o texto selecionado para a área de transferência (Ctrl + C)
pyautogui.hotkey('ctrl', 'c')

# Obtém o texto copiado da área de transferência usando pyperclip
texto_copiado = pyperclip.paste()

# Fecha o DevTools (Ctrl + Shift + I novamente para fechá-lo)
pyautogui.hotkey('ctrl', 'shift', 'i')
pyautogui.hotkey('ctrl', 'w')

# Função para processar os dados copiados e convertê-los em JSON
from bs4 import BeautifulSoup
import json

def processar_dados(html_text):
    soup = BeautifulSoup(html_text, 'html.parser')

    dados_basicos = {}
    cadin = {
        "Sequencia": {
            "Até 30 dias Contratos em atraso": "",
            "Após 30 dias Contratos em atraso": ""
        },
        "Registros": []
    }
    pendencias_refin_pefin = []
    scpc = []
    protesto = []
    serasa = {
        "Ocorrencias": []
    }
    cheque_sem_fundos = []

    # Encontrar todas as tabelas
    tabelas = soup.find_all('table', class_='table-striped')

    for tabela in tabelas:
        titulo = tabela.find('td', class_='bg-maxbuscas')
        if titulo:
            titulo_texto = titulo.get_text(strip=True)

            if "DADOS BASICOS" in titulo_texto:
                # Extrair dados básicos
                linhas = tabela.find_all('tr')
                for linha in linhas:
                    colunas = linha.find_all('td')
                    if len(colunas) == 2:
                        chave = colunas[0].get_text(strip=True).replace(':', '')
                        valor = colunas[1].get_text(strip=True)
                        dados_basicos[chave] = valor

            elif "CADIN" in titulo_texto:
                # Extrair CADIN
                sequencias = tabela.find('tr', class_='text-center')
                if sequencias:
                    colunas = sequencias.find_all('td')
                    if len(colunas) == 3:
                        cadin["Sequencia"]["Até 30 dias Contratos em atraso"] = colunas[1].get_text(strip=True)
                        cadin["Sequencia"]["Após 30 dias Contratos em atraso"] = colunas[2].get_text(strip=True)

                registros = tabela.find_all('tr', class_='text-center')
                for registro in registros:
                    colunas = registro.find_all('td')
                    if len(colunas) == 3:
                        registro_dict = {
                            "Sigla Credor": colunas[0].get_text(strip=True),
                            "Nome Credor": colunas[1].get_text(strip=True),
                            "Data Primeira Ocorrencia": colunas[2].get_text(strip=True)
                        }
                        cadin["Registros"].append(registro_dict)

            elif "Pendências REFIN/PEFIN" in titulo_texto:
                # Extrair Pendências REFIN/PEFIN
                registros = tabela.find_all('tr', class_='text-center')
                for registro in registros:
                    colunas = registro.find_all('td')
                    if len(colunas) == 7:
                        registro_dict = {
                            "Data": colunas[0].get_text(strip=True),
                            "Tipo Financ.": colunas[1].get_text(strip=True),
                            "Aval": colunas[2].get_text(strip=True),
                            "Valor (R$)": colunas[3].get_text(strip=True),
                            "Contrato": colunas[4].get_text(strip=True),
                            "Origem": colunas[5].get_text(strip=True),
                            "Cidade": colunas[6].get_text(strip=True)
                        }
                        pendencias_refin_pefin.append(registro_dict)

            elif "SCPC" in titulo_texto:
                # Extrair SCPC
                registros = tabela.find_all('tr', class_='text-center')
                for registro in registros:
                    colunas = registro.find_all('td')
                    if len(colunas) == 8:
                        registro_dict = {
                            "Dt Ocorr": colunas[0].get_text(strip=True),
                            "Tp Devedor": colunas[1].get_text(strip=True),
                            "Nome": colunas[2].get_text(strip=True),
                            "Vr Divida": colunas[3].get_text(strip=True),
                            "Cidade": colunas[4].get_text(strip=True),
                            "UF": colunas[5].get_text(strip=True),
                            "Contrato": colunas[6].get_text(strip=True),
                            "Dt Disp": colunas[7].get_text(strip=True)
                        }
                        scpc.append(registro_dict)

            elif "Protesto" in titulo_texto:
                # Extrair Protesto
                registros = tabela.find_all('tr', class_='text-center')
                for registro in registros:
                    colunas = registro.find_all('td')
                    if len(colunas) == 5:
                        registro_dict = {
                            "Data": colunas[0].get_text(strip=True),
                            "Valor Protesto": colunas[1].get_text(strip=True),
                            "Cartorio": colunas[2].get_text(strip=True),
                            "Cidade": colunas[3].get_text(strip=True),
                            "UF": colunas[4].get_text(strip=True)
                        }
                        protesto.append(registro_dict)

            elif "SERASA" in titulo_texto:
                # Extrair SERASA
                ocorrencias = tabela.find_all('tr', class_='text-center')
                for ocorrencia in ocorrencias:
                    colunas = ocorrencia.find_all('td')
                    if len(colunas) == 3:
                        ocorrencia_dict = {
                            "Data Primeira Ocorrência": colunas[0].get_text(strip=True),
                            "Data Última Ocorrência": colunas[1].get_text(strip=True),
                            "Quantidade Ocorrências": colunas[2].get_text(strip=True)
                        }
                        serasa["Ocorrencias"].append(ocorrencia_dict)

            elif "Cheque sem Fundos" in titulo_texto:
                # Extrair Cheque sem Fundos
                registros = tabela.find_all('tr', class_='text-center')
                for registro in registros:
                    colunas = registro.find_all('td')
                    if len(colunas) == 9:
                        registro_dict = {
                            "Data": colunas[0].get_text(strip=True),
                            "Cheque": colunas[1].get_text(strip=True),
                            "Alinea": colunas[2].get_text(strip=True),
                            "Qtd Cheque": colunas[3].get_text(strip=True),
                            "Vlr Cheque": colunas[4].get_text(strip=True),
                            "Banco": colunas[5].get_text(strip=True),
                            "Agência": colunas[6].get_text(strip=True),
                            "Cidade": colunas[7].get_text(strip=True),
                            "UF": colunas[8].get_text(strip=True)
                        }
                        cheque_sem_fundos.append(registro_dict)

    # Montar o dicionário final
    dados_final = {
        "DADOS BASICOS": dados_basicos,
        "CADIN": cadin,
        "SERASA": serasa,
        "Pendências REFIN/PEFIN": pendencias_refin_pefin,
        "SCPC": scpc,
        "Protesto": protesto,
        "Cheque sem Fundos": cheque_sem_fundos
    }

    # Imprimir os dados finais em formato JSON
    print(json.dumps(dados_final, indent=4))

if texto_copiado:
    processar_dados(texto_copiado)
else:
    print("Nenhum texto encontrado na área de transferência.")


# Parar o cronômetro e calcular o tempo total
# end_time = time.time()
# total_time = end_time - start_time

# Imprimir o tempo total no console
# print("Tempo total de execução:", total_time, "segundos")
