import time
import pygetwindow as gw
import pyautogui
import pyperclip
import os
import json
from pywinauto import mouse

pyautogui.FAILSAFE = False

# Caminho para o arquivo accounts.json local
accounts_json_file = r"C:\xampp\htdocs\account\accounts.json"

# Função para executar logout
def executar_logout():
    script_path = r"C:\Users\Administrator\Desktop\Arthur-KingBuscas\src\api\maxbuscas\logout.py"
    if os.path.exists(script_path):
        os.system(f"start /b python {script_path}")
    else:
        print(f"Erro: Não foi possível encontrar o script {script_path}.")

# Função para carregar o JSON de contas a partir do arquivo local
def load_accounts_from_file(json_file):
    try:
        with open(json_file, 'r') as file:
            accounts = json.load(file)
        return accounts
    except FileNotFoundError:
        print(f"Arquivo JSON não encontrado: {json_file}")
        return None
    except json.JSONDecodeError as e:
        print(f"Erro ao decodificar JSON: {e}")
        return None

# Função para salvar o JSON de contas de volta ao arquivo
def save_accounts_to_file(accounts, json_file):
    try:
        with open(json_file, 'w') as file:
            json.dump(accounts, file, indent=2)
        print(f"Dados salvos em {json_file}")
    except Exception as e:
        print(f"Erro ao salvar JSON em {json_file}: {e}")

# Função para encontrar a primeira conta 'active', mudar para 'inactive' e mover para o final
def update_first_active_account_to_inactive(accounts):
    if not accounts or 'users' not in accounts:
        print("JSON de contas inválido ou vazio.")
        return False
    
    index_to_move = None
    
    for index, user in enumerate(accounts['users']):
        if user.get('status') == 'active':
            user['status'] = 'inactive'
            index_to_move = index
            break  # Para no primeiro usuário 'active' encontrado
    
    if index_to_move is not None:
        # Mover o usuário para o final da lista
        accounts['users'].append(accounts['users'].pop(index_to_move))
        return True
    else:
        print("Nenhuma conta 'active' encontrada para atualizar.")
        return False

# Carregar o JSON de contas a partir do arquivo local
accounts = load_accounts_from_file(accounts_json_file)

# Verificar se o carregamento foi bem-sucedido
if not accounts:
    print("Não foi possível carregar as contas do arquivo JSON.")
    exit()

# Encontrar a janela do Chrome
chrome_window = gw.getWindowsWithTitle("Google Chrome")[0]
chrome_window.activate()

# Simular as teclas de atalho para abrir uma nova guia
pyautogui.hotkey('ctrl', 't')
time.sleep(1)

# Simular a digitação da URL na barra de endereço do Chrome
pyautogui.write("https://maxbuscas.info/app", interval=0.05)
pyautogui.press('enter')
time.sleep(3)  # Aumente se necessário para garantir que a página carregue completamente

# URL da página que estamos verificando
url_bases = "https://maxbuscas.info/app"
pyautogui.hotkey('ctrl', 'l')  # Seleciona a barra de endereço
pyautogui.hotkey('ctrl', 'c')  # Copia o conteúdo da barra de endereço
url = pyperclip.paste()

if url == url_bases:
    js_code = r"""
        (function() {
            let parentElement = document.getElementById('38');
            if (parentElement) {
                let divElement = parentElement.querySelector('.ribbon-2');
                if (divElement) {
                    let textContent = divElement.textContent.trim();
                    var tempInput = document.createElement('input');
                    tempInput.style = 'position: absolute; left: -1000px; top: -1000px';
                    tempInput.value = textContent.replace(/\s/g, '');
                    document.body.appendChild(tempInput);
                    tempInput.select();
                    document.execCommand('copy');
                    document.body.removeChild(tempInput);
                    return textContent.replace(/\s/g, '');
                } else {
                    return 'Elemento filho não encontrado';
                }
            } else {
                return 'Elemento pai não encontrado';
            }
        })();
    """

    time.sleep(2)
    # Simula a abertura do console do navegador
    pyautogui.hotkey('ctrl', 'shift', 'j')
    time.sleep(2)

    # Cola o código JavaScript no console
    pyperclip.copy(js_code)
    pyautogui.hotkey('ctrl', 'v')
    pyautogui.press('enter')
    time.sleep(2)

    # Copiar o resultado do console
    x_consulta, y_consulta = 1267, 310
    mouse.click(coords=(x_consulta, y_consulta))
    pyautogui.press('down')
    pyautogui.hotkey('ctrl', 'c')  # Copia o texto selecionado
    time.sleep(3)

    # Obtém o texto copiado
    result = pyperclip.paste()
    time.sleep(2)
    # print(f"Texto copiado: {result}")

    # Verifica o valor obtido
    if '40/40' in result:
        # print("Resultado é 40/40")
        # Atualizar a primeira conta 'active' para 'inactive' e mover para o final
        if update_first_active_account_to_inactive(accounts):
            # Salvar alterações de volta ao arquivo
            save_accounts_to_file(accounts, accounts_json_file)
            # print("Conta 'active' atualizada para 'inactive' e movida para o final:")
            pyautogui.hotkey('ctrl', 'w')
            executar_logout()
        else:
            print("Não foi possível atualizar a conta 'active'.")
    else:
        # print("Resultado não é 40/40")
        pyautogui.hotkey('ctrl', 'w')
else:
    print("Página com problemas para execução.")
