import fs from 'fs';
const accountsFilePath = 'C:\\xampp\\htdocs\\account\\accounts.json';

// Função para modificar o status da primeira conta para "ocupado"
export const markFirstAccountAsBusy = () => {
    fs.readFile(accountsFilePath, 'utf8', (err, data) => {
        if (err) {
            console.error('Erro ao ler o arquivo de contas:', err);
            return;
        }

        let accounts = JSON.parse(data);
        if (accounts.users.length > 0) {
            // Marca a primeira conta como ocupada
            accounts.users[0].status = 'busy';

            // Salva as alterações de volta no arquivo JSON
            fs.writeFile(accountsFilePath, JSON.stringify(accounts, null, 2), 'utf8', (err) => {
                if (err) {
                    console.error('Erro ao atualizar o status da conta:', err);
                } else {
                    console.log('Status da primeira conta atualizado para "ocupado".');
                }
            });
        } else {
            console.error('Nenhuma conta encontrada no arquivo.');
        }
    });
};

// Função para modificar o status da primeira conta para "ativo"
export const markFirstAccountAsActive = () => {
    fs.readFile(accountsFilePath, 'utf8', (err, data) => {
        if (err) {
            console.error('Erro ao ler o arquivo de contas:', err);
            return;
        }

        let accounts = JSON.parse(data);
        if (accounts.users.length > 0) {
            // Marca a primeira conta como ativa novamente
            accounts.users[0].status = 'active';

            // Salva as alterações de volta no arquivo JSON
            fs.writeFile(accountsFilePath, JSON.stringify(accounts, null, 2), 'utf8', (err) => {
                if (err) {
                    console.error('Erro ao atualizar o status da conta:', err);
                } else {
                    console.log('Status da primeira conta atualizado para "active".');
                }
            });
        } else {
            console.error('Nenhuma conta encontrada no arquivo.');
        }
    });
};