import puppeteer from 'puppeteer';
import { timeout } from 'puppeteer';

async function login(page) {
    // Faz login
    await page.goto('https://newbuscas.tech/Login', {
        waitUntil: 'networkidle2',
        timeout: 0 // Definindo timeout como 0 para desabilitar
    });
    console.log('Navigated to login page');

    await page.type('#username', 'arthurbaldiotti');
    await page.type('#password-input', '10203040');
    console.log('Username and password entered');

    await page.click('.btn-success');
    console.log('Clicked on login button');

    // Aguarda até que a página de login seja completamente carregada
    // await page.waitForNavigation({ waitUntil: 'networkidle2' });
    console.log('Logged in successfully');
}

async function CADSUS(cpf) {
    console.log('Start of test.js');
    let browser;
    let page;

    try {
        console.time('Total execution time'); // Inicia o cronômetro

        browser = await puppeteer.launch({
            headless: false,
            args: [
                '--no-sandbox',
                '--disable-setuid-sandbox',
                '--disable-extensions',
                '--clipboard-read', // Permissão para leitura da área de transferência
                '--start-maximized'
            ],
        });
        page = await browser.newPage();

        // Defina permissões para acessar a área de transferência
        const context = browser.defaultBrowserContext();
        await context.overridePermissions('https://newbuscas.tech', ['clipboard-read', 'clipboard-write']);

        await page.setViewport({ width: 1366, height: 768 });
        await page.evaluate(() => {
            document.body.style.zoom = "100%";
        });
        await login(page);
        // Aguarda até que o elemento .callout.callout-success seja encontrado
        await page.waitForSelector('.callout.callout-success', { timeout: 5000 }).catch(() => null);
       const result = await CadSUS(page);
       return result;
    } catch (error) {
        console.log('Error:', error);
    } finally {
        if (browser) {
            await browser.close();
        }

        console.timeEnd('Total execution time'); // Finaliza o cronômetro e imprime o tempo decorrido
    }
}


async function CadSUS(page) {
    try {
        // Aguarda até que a imagem seja visível na página
        await page.waitForSelector('img.zoom-image[src="assets/img/cadsus.png"]');

        // Localiza a imagem e clica nela
        const image = await page.$('img.zoom-image[src="assets/img/cadsus.png"]');
        await image.click();

        // Aguarda até que o campo de CPF seja visível na página e insere o CPF
        await page.waitForSelector('input[name="cpf"]');
        const cpf = '32676277880';
        await page.$eval('input[name="cpf"]', (element, cpf) => {
            element.value = cpf;
        }, cpf);

        // Aguarda até que o botão de consultar seja visível na página e clica nele
        await page.waitForSelector('button.btn.btn-primary');
        const consultarButton = await page.$('button.btn.btn-primary');
        await consultarButton.click();

        // Aguarda um período suficiente após clicar em Consultar
        await page.waitForTimeout(5000); // Ajuste o tempo conforme necessário

        // Verifica se o elemento de Informações Básicas existe antes de clicar no botão Copiar
        const infoBasicaSelector = 'td.p-1.text-center.fw-bold.fs-3[colspan="4"]';
        const infoBasicaElement = await page.$(infoBasicaSelector);
        if (infoBasicaElement) {
            // Aguarda até que o botão de copiar seja visível na página
            await page.waitForSelector('button#botaoCopiar');

            // Aguarda um curto período após o botão de copiar ser visível
            await page.waitForTimeout(3000); // Ajuste o tempo conforme necessário

            // Clica no botão de copiar
            const botaoCopiar = await page.$('button#botaoCopiar');
            await botaoCopiar.click();

            // Aguarda um período suficiente para garantir que o conteúdo foi copiado para a área de transferência
            await page.waitForTimeout(10000); // Ajuste o tempo conforme necessário

            // Utiliza o Chrome DevTools Protocol para obter o texto copiado diretamente
            const conteudoCopiado = await page.evaluate(() => {
                return navigator.clipboard.readText();
            });

            // Função para extrair os dados de cada seção
            const extrairDados = (conteudo, secao) => {
                const regex = new RegExp(`(${secao})([\\s\\S]*?)(?=(ENDEREÇO|TELEFONE|DOCUMENTO|$))`, 'g');
                const match = regex.exec(conteudo);
                if (!match) return {};

                const lines = match[2].trim().split(/\n+/);
                const data = {};
                lines.forEach(line => {
                    const [key, ...values] = line.split('\t').map(item => item.trim());
                    const value = values.join(' ');
                    if (key && value) {
                        data[key] = value;
                    }
                });
                return data;
            };

            // Função para extrair o endereço
            const extrairEndereco = (conteudo) => {
                const regex = /ENDEREÇO\s*([\s\S]*?)(?=(TELEFONE|DOCUMENTO|$))/g;
                const match = regex.exec(conteudo);
                if (!match) return {};

                const endereco = match[1].trim().split(/,\s+/).map(item => item.trim());
                return { endereco: endereco.join(', ') };
            };

            // Função para extrair telefone
            const extrairTelefone = (conteudo) => {
                const regex = /TELEFONE\s*TIPO TELEFONE\s*NÚMERO\s*AÇÕES([\s\S]*?)(?=(DOCUMENTO|$))/g;
                const match = regex.exec(conteudo);
                if (!match) return [];

                const lines = match[1].trim().split(/\n+/);
                const telefones = lines.map(line => {
                    const [tipo, numero] = line.split('\t').map(item => item.trim());
                    return { tipo, numero };
                });

                return telefones;
            };

            // Função para extrair documento
            const extrairDocumento = (conteudo) => {
                const regex = /DOCUMENTO\s*NÚMERO RG\s*ÓRGÃO EMISSOR\s*ESTADO EMISSOR\s*DATA EMISSÃO([\s\S]*?)(?=$)/g;
                const match = regex.exec(conteudo);
                if (!match) return [];

                const lines = match[1].trim().split(/\n+/);
                const documentos = lines.map(line => {
                    const [numero, orgao, estado, data] = line.split('\t').map(item => item.trim());
                    return { numero, orgao, estado, data };
                });

                return documentos;
            };

        // Extrair dados de todas as seções principais
        const dadosPessoais = extrairDados(conteudoCopiado, 'DADOS PESSOAIS');
        const endereco = extrairEndereco(conteudoCopiado);
        const telefone = extrairTelefone(conteudoCopiado);
        const documento = extrairDocumento(conteudoCopiado);

        // Formatação final dos dados
        const dataFormatada = {
            dadosPessoais,
            endereco,
            telefone,
            documento,
        };

        // console.log('Dados extraídos com sucesso:', dataFormatada);
        return dataFormatada; 
    }} catch (error) {
        console.log('Erro ao clicar no botão Consultar ou extrair dados:', error);
        return null;
    }
}


export { CADSUS };
// CADSUS();
