import puppeteer from 'puppeteer';
import {v4 as uuidv4} from 'uuid';
import fs from 'fs';
import fetch from 'node-fetch';

async function login(page) {
    // Faz login
    await page.goto('https://newbuscas.tech/Login', {
        waitUntil: 'networkidle2',
        timeout: 0 // Definindo timeout como 0 para desabilitar
    });
    console.log('Navigated to login page');

    await page.type('#username', 'arthurbaldiotti');
    await page.type('#password-input', '10203040');
    console.log('Username and password entered');

    await page.click('.btn-success');
    console.log('Clicked on login button');

    // Aguarda até que a página de login seja completamente carregada
    // await page.waitForNavigation({ waitUntil: 'networkidle2' });
    console.log('Logged in successfully');
}

async function FotoCPF(cpf) {
    console.log('Start of test.js');
    let browser;
    let page;

    try {
        console.time('Total execution time'); // Inicia o cronômetro

        browser = await puppeteer.launch({
            headless: false,
            args: [
                '--no-sandbox',
                '--disable-setuid-sandbox',
                '--disable-extensions',
                '--clipboard-read', // Permissão para leitura da área de transferência
                '--start-maximized'
            ],
        });
        page = await browser.newPage();
        await page.setViewport({ width: 1366, height: 768 });
        await page.evaluate(() => {
            document.body.style.zoom = "100%";
        });
        await login(page);
        // Aguarda até que o elemento .callout.callout-success seja encontrado
        await page.waitForSelector('div.card-header.bg-primary.bg-gradient.pt-2.pb-1 h3.text-white.fs-4.text-uppercase', { timeout: 5000 }).catch(() => null);
        const result = await consultacpftop(page, cpf);
        return result;
    } catch (error) {
        console.log('Error:', error);
    } finally {
        if (browser) {
            await browser.close();
        }

        console.timeEnd('Total execution time'); // Finaliza o cronômetro e imprime o tempo decorrido
    }
}

async function downloadImage(src) {
    const response = await fetch(src);
    const buffer = await response.arrayBuffer();
    const filename = `${uuidv4()}.png`; // Nome do arquivo gerado aleatoriamente

    // Converter ArrayBuffer em Buffer
    const bufferData = Buffer.from(buffer);

    // Escrever o Buffer no arquivo na pasta desejada na sua VPS
    const path = `C:/xampp/htdocs/pictures/${filename}`; // Substitua pelo caminho da sua pasta na VPS
    fs.writeFile(path, bufferData, (err) => {
        if (err) {
            console.error('Erro ao escrever o arquivo:', err);
        } else {
            console.log('Imagem baixada com sucesso:', filename);
        }
    });

    const link = `http://104.234.224.187:8080/pictures/${filename}`; // Substitua pelo seu endereço real
    return { filename, link };
}

async function consultacpftop(page, cpf) {
    try {
        // Aguarda até que a imagem seja visível na página
        await page.waitForSelector('img.zoom-image[src="assets/img/foto.png"]');

        // Localiza a imagem
        const image = await page.$('img.zoom-image[src="assets/img/foto.png"]');

        // Clica na imagem
        await image.click();

        // Aguarda até que o campo de CPF seja visível na página
        await page.waitForSelector('input[name="cpf"]');

        // Função para filtrar apenas números
        const filtrarSomenteNumeros = (input) => {
            const value = input.value;
            input.value = value.replace(/\D/g, '');
        };

        // Inserir CPF no campo (exemplo)
        await page.$eval('input[name="cpf"]', (element, cpf) => {
            element.value = cpf;
        }, cpf);

        // Aguarda até que o botão de consultar seja visível na página
        await page.waitForSelector('button.btn.btn-primary');

        // Localiza o botão de consultar
        const consultarButton = await page.$('button.btn.btn-primary');

        // Clica no botão de consultar
        await consultarButton.click();
        
        await page.waitForSelector('table.table-responsive');

        // Localiza a imagem dentro da tabela
        const imageInTable = await page.$('table.table-responsive img');
        const src = await imageInTable.evaluate(node => node.getAttribute('src'));

        // Baixa a imagem e retorna o nome do arquivo baixado e o link para baixar
        const { filename, link } = await downloadImage(src);

        if (filename && link) {
            // Construir o objeto JSON com as informações da imagem
            const jsonResult = { imagem: link };
        
            // Retornar o objeto JSON como resposta
            return jsonResult;
        } else {
            // Se ocorrer um erro ou a imagem não for encontrada, retorne uma mensagem de erro
            return { erro: 'Imagem não encontrada ou ocorreu um erro durante o processo de download' };
        }
        

    } catch (error) {
        console.log('Error clicking on the image or inserting CPF:', error);
        return null;
    }
}

// Chama checkPage() para iniciar o processo
export { FotoCPF }
