import puppeteer from 'puppeteer';
import { timeout } from 'puppeteer';

async function login(page) {
    // Faz login
    await page.goto('https://newbuscas.tech/Login', {
        waitUntil: 'networkidle2',
        timeout: 0 // Definindo timeout como 0 para desabilitar
    });
    console.log('Navigated to login page');

    await page.type('#username', 'arthurbaldiotti');
    await page.type('#password-input', '10203040');
    console.log('Username and password entered');

    await page.click('.btn-success');
    console.log('Clicked on login button');

    // Aguarda até que a página de login seja completamente carregada
    // await page.waitForNavigation({ waitUntil: 'networkidle2' });
    console.log('Logged in successfully');
}

async function NomeDetalhados(nome, sobrenome) {
    console.log('Start of test.js');
    let browser;
    let page;

    try {
        browser = await puppeteer.launch({
            headless: false,
            args: [
                '--no-sandbox',
                '--disable-setuid-sandbox',
                '--disable-extensions',
                '--clipboard-read', // Permissão para leitura da área de transferência
                '--start-maximized'
            ],
        });
        page = await browser.newPage();

        // Defina permissões para acessar a área de transferência
        const context = browser.defaultBrowserContext();
        await context.overridePermissions('https://newbuscas.tech', ['clipboard-read', 'clipboard-write']);

        await page.setViewport({ width: 1366, height: 768 });
        await page.evaluate(() => {
            document.body.style.zoom = "100%";
        });
        await login(page);
        // Aguarda até que o elemento .callout.callout-success seja encontrado
        await page.waitForSelector('.callout.callout-success', { timeout: 5000 }).catch(() => null);
       const result = await NomeDetalhado(page, nome, sobrenome);
       return result;
    } catch (error) {
        console.log('Error:', error);
    } finally {
        if (browser) {
            // await browser.close();
        }

    }
}


async function NomeDetalhado(page, nome, sobrenome) {
    try {
        // Aguarda até que a imagem seja visível na página
        await page.waitForSelector('img.zoom-image[src="assets/img/nome.png"]');

        // Localiza a imagem e clica nela
        const image = await page.$('img.zoom-image[src="assets/img/nome.png"]');
        await image.click();

        // const nome = 'Matheus'
        // const sobrenome = 'Santos Alves da Silva'
        // Aguarda até que o campo de CPF seja visível na página e insere o CPF
        await page.waitForSelector('input[name="PN"]');
        await page.$eval('input[name="PN"]', (element, nome) => {
            element.value = nome;
        }, nome);

        await page.waitForSelector('input[name="MN"]');
        await page.$eval('input[name="MN"]', (element, sobrenome) => {
            element.value = sobrenome;
        }, sobrenome);

        // Aguarda até que o botão de consultar seja visível na página e clica nele
        await page.waitForSelector('button.btn.btn-primary');
        const consultarButton = await page.$('button.btn.btn-primary');
        await consultarButton.click();

        // Aguarda um período suficiente após clicar em Consultar
        await page.waitForTimeout(10000); // Ajuste o tempo conforme necessário
        // Aguarda até que o botão de copiar seja visível na página
            await page.waitForSelector('button#botaoCopiar');

            // Aguarda um curto período após o botão de copiar ser visível
            await page.waitForTimeout(5000); // Ajuste o tempo conforme necessário

            // Clica no botão de copiar
            const botaoCopiar = await page.$('button#botaoCopiar');
            await botaoCopiar.click();

            // Aguarda um período suficiente para garantir que o conteúdo foi copiado para a área de transferência
            await page.waitForTimeout(5000); // Ajuste o tempo conforme necessário

            // Utiliza o Chrome DevTools Protocol para obter o texto copiado diretamente
            const conteudoCopiado = await page.evaluate(() => {
                return navigator.clipboard.readText();
            });
            const extrairDados = (conteudo) => {
                const regex = /CONSULTAR\s*(.*?)\t(.*?)\t(.*?)\t(.*?)\t(.*?)\t(.*?)$/gm;
                const dados = [];
                let match;
            
                while ((match = regex.exec(conteudo)) !== null) {
                    const [, nome, cpf, nomeMae, nascimento, cidade, renda] = match;
            
                    dados.push({
                        nome: nome.trim() || '',
                        cpf: cpf.trim() || '',
                        nomeMae: nomeMae.trim() || '',
                        nascimento: nascimento.trim() || '',
                        cidade: cidade.trim() || '',
                        renda: renda.trim() || '',
                    });
                }
            
                return dados;
            };

            // Extrair dados de todas as seções principais
            const dados = extrairDados(conteudoCopiado);
            return dados;

            // console.log(dados)
    } catch (error) {
        console.log('Erro ao clicar no botão Consultar ou extrair dados:', error);
        return null;
    }
}

export { NomeDetalhados };
// NomeDetalhados()
