import puppeteer from 'puppeteer';
import { timeout } from 'puppeteer';

async function login(page) {
    // Faz login
    await page.goto('https://newbuscas.tech/Login', {
        waitUntil: 'networkidle2',
        timeout: 0 // Definindo timeout como 0 para desabilitar
    });
    console.log('Navigated to login page');

    await page.type('#username', 'arthurbaldiotti');
    await page.type('#password-input', '10203040');
    console.log('Username and password entered');

    await page.click('.btn-success');
    console.log('Clicked on login button');

    // Aguarda até que a página de login seja completamente carregada
    // await page.waitForNavigation({ waitUntil: 'networkidle2' });
    console.log('Logged in successfully');
}

async function RECEITAFEDERAL(cpf) {
    console.log('Start of test.js');
    let browser;
    let page;

    try {
        browser = await puppeteer.launch({
            headless: 'auto',
            args: [
                '--no-sandbox',
                '--disable-setuid-sandbox',
                '--disable-extensions',
                '--clipboard-read', // Permissão para leitura da área de transferência
                '--start-maximized'
            ],
        });
        page = await browser.newPage();

        // Defina permissões para acessar a área de transferência
        const context = browser.defaultBrowserContext();
        await context.overridePermissions('https://newbuscas.tech', ['clipboard-read', 'clipboard-write']);

        await page.setViewport({ width: 1366, height: 768 });
        await page.evaluate(() => {
            document.body.style.zoom = "100%";
        });
        await login(page);
        // Aguarda até que o elemento .callout.callout-success seja encontrado
        await page.waitForSelector('.callout.callout-success', { timeout: 5000 }).catch(() => null);
       const result = await ReceitaFederal(page, cpf);
       return result;
    } catch (error) {
        console.log('Error:', error);
    } finally {
        if (browser) {
            // await browser.close();
        }

    }
}


async function ReceitaFederal(page, cpf) {
    try {
        // Aguarda até que a imagem seja visível na página
        await page.waitForSelector('img.zoom-image[src="assets/img/receita.png"]');

        // Localiza a imagem e clica nela
        const image = await page.$('img.zoom-image[src="assets/img/receita.png"]');
        await image.click();

        // Aguarda até que o campo de CPF seja visível na página e insere o CPF
        await page.waitForSelector('input[name="cpf"]');
        await page.$eval('input[name="cpf"]', (element, cpf) => {
            element.value = cpf;
        }, cpf);

        // Aguarda até que o botão de consultar seja visível na página e clica nele
        await page.waitForSelector('button.btn.btn-primary');
        const consultarButton = await page.$('button.btn.btn-primary');
        await consultarButton.click();

        // Aguarda um período suficiente após clicar em Consultar
        await page.waitForTimeout(5000); // Ajuste o tempo conforme necessário

        const infoBasicaSelector = 'td.p-1.fs-3.text-white.text-center[colspan="2"]';
        const infoBasicaElement = await page.$(infoBasicaSelector);
        if (infoBasicaElement) {
            // Aguarda até que o botão de copiar seja visível na página
            await page.waitForSelector('button#botaoCopiar');

            // Aguarda um curto período após o botão de copiar ser visível
            await page.waitForTimeout(3000); // Ajuste o tempo conforme necessário

            // Clica no botão de copiar
            const botaoCopiar = await page.$('button#botaoCopiar');
            await botaoCopiar.click();

            // Aguarda um período suficiente para garantir que o conteúdo foi copiado para a área de transferência
            await page.waitForTimeout(10000); // Ajuste o tempo conforme necessário

            // Utiliza o Chrome DevTools Protocol para obter o texto copiado diretamente
            const conteudoCopiado = await page.evaluate(() => {
                return navigator.clipboard.readText();
            });
            // Função para extrair os dados de cada seção
            const extrairDados = (conteudo) => {
                const regex = /DADOS\s*([\s\S]*?)(?=ENDEREÇO|MUNICÍPIO - UF|$)/g;
                const match = regex.exec(conteudo);
                if (!match) return {};

                const lines = match[1].trim().split(/\n+/);
                const data = {};
                lines.forEach(line => {
                    const [key, ...values] = line.split('\t').map(item => item.trim());
                    const value = values.join(' ');
                    if (key && value) {
                        data[key] = value;
                    }
                });
                return data;
            };

            // Função para extrair o endereço
            const extrairEndereco = (conteudo) => {
                const regex = /ENDEREÇO\s*([\s\S]*?)(?=MUNICÍPIO - UF|$)/g;
                const match = regex.exec(conteudo);
                if (!match) return {};

                const endereco = match[1].trim().split(/,\s+/).map(item => item.trim());
                return { endereco: endereco.join(', ') };
            };

            // Função para extrair município e UF
            const extrairMunicipioUf = (conteudo) => {
                const regex = /MUNICÍPIO - UF\s*([\s\S]*?)(?=$)/g;
                const match = regex.exec(conteudo);
                if (!match) return {};

                const [municipio, uf] = match[1].trim().split(/\s*-\s*/).map(item => item.trim());
                return { municipio, uf };
            };

            // Extrair dados de todas as seções principais
            const dados = extrairDados(conteudoCopiado);
            const endereco = extrairEndereco(conteudoCopiado);
            const municipioUf = extrairMunicipioUf(conteudoCopiado);

            // Formatação final dos dados
            const dataFormatada = {
                dados,
                endereco,
                municipioUf,
            };

            // console.log('Dados extraídos com sucesso:', dataFormatada);
            return dataFormatada; 
        }
    } catch (error) {
        console.log('Erro ao clicar no botão Consultar ou extrair dados:', error);
        return null;
    }
}



export { RECEITAFEDERAL };
// RECEITAFEDERAL();
