import puppeteer from 'puppeteer';

async function login(page) {
    // Faz login
    await page.goto('https://newbuscas.tech/Login', {
        waitUntil: 'networkidle2',
        timeout: 0 // Definindo timeout como 0 para desabilitar
    });
    console.log('Navigated to login page');

    await page.type('#username', 'arthurbaldiotti');
    await page.type('#password-input', '10203040');
    console.log('Username and password entered');

    await page.click('.btn-success');
    console.log('Clicked on login button');

    // Aguarda até que a página de login seja completamente carregada
    // await page.waitForNavigation({ waitUntil: 'networkidle2' });
    console.log('Logged in successfully');
}

async function ScoreNew(cpf) {
    console.log('Start of test.js');
    let browser;
    let page;

    try {
        console.time('Total execution time'); // Inicia o cronômetro

        browser = await puppeteer.launch({
            headless: 'auto',
            args: [
                '--no-sandbox',
                '--disable-setuid-sandbox',
                '--disable-extensions',
                '--clipboard-read', // Permissão para leitura da área de transferência
                '--start-maximized'
            ],
        });
        page = await browser.newPage();
        await page.setViewport({ width: 1366, height: 768 });
        await page.evaluate(() => {
            document.body.style.zoom = "100%";
        });
        await login(page);
        // Aguarda até que o elemento .callout.callout-success seja encontrado
        await page.waitForSelector('div.card-header.bg-primary.bg-gradient.pt-2.pb-1 h3.text-white.fs-4.text-uppercase', { timeout: 5000 }).catch(() => null);
        const result = await consultacpftop(page, cpf);
        return result;
    } catch (error) {
        console.log('Error:', error);
    } finally {
        if (browser) {
            await browser.close();
        }

        console.timeEnd('Total execution time'); // Finaliza o cronômetro e imprime o tempo decorrido
    }
}

async function consultacpftop(page, cpf) {
    try {
        // Aguarda até que a imagem seja visível na página
        await page.waitForSelector('img.zoom-image[src="assets/img/score-pf.png"]');

        // Localiza a imagem
        const image = await page.$('img.zoom-image[src="assets/img/score-pf.png"]');

        // Clica na imagem
        await image.click();

        // Aguarda até que o campo de CPF seja visível na página
        await page.waitForSelector('input[name="cpf"]');

        // Função para filtrar apenas números
        const filtrarSomenteNumeros = (input) => {
            const value = input.value;
            input.value = value.replace(/\D/g, '');
        };

        // Inserir CPF no campo (exemplo)
        await page.$eval('input[name="cpf"]', (element, cpf) => {
            element.value = cpf;
        }, cpf);

        // Aguarda até que o botão de consultar seja visível na página
        await page.waitForSelector('button.btn.btn-primary');

        // Localiza o botão de consultar
        const consultarButton = await page.$('button.btn.btn-primary');

        // Clica no botão de consultar
        await consultarButton.click();
        
        // Aguarda até que a tabela "Score" seja visível na página
        await page.waitForSelector('table.table.text-uppercase');

        // Extrai os resultados da tabela "Score"
        const scoreResults = await page.evaluate(() => {
            const scoreTable = document.querySelector('table.table.text-uppercase');

            const title = scoreTable.querySelector('td[colspan="4"]').innerText.trim();
            const scoreValue = scoreTable.querySelector('td[colspan="4"] div').innerText.trim();

            return { [title]: scoreValue };
        });

        // Aguarda até que a tabela "Dados Pessoais" seja visível na página
        await page.waitForSelector('table.table.text-uppercase');

        // Extrai os resultados da tabela "Dados Pessoais"
        const dadosPessoaisResults = await page.evaluate(() => {
            const dadosPessoaisTable = document.querySelectorAll('table.table.text-uppercase')[1];
            const rows = dadosPessoaisTable.querySelectorAll('tbody tr');

            const data = {};

            rows.forEach(row => {
                const cells = row.querySelectorAll('td[colspan="2"]');
                if (cells.length === 2) {
                    const key = cells[0].innerText.trim();
                    const value = cells[1].innerText.trim();
                    data[key] = value;
                }
            });

            return data;
        });

        // Aguarda até que a tabela "Endereço" seja visível na página
        await page.waitForSelector('table.table.text-uppercase');

        // Extrai os resultados da tabela "Endereço"
        const enderecoResults = await page.evaluate(() => {
            const enderecoTable = Array.from(document.querySelectorAll('table.table.text-uppercase')).find(table => table.textContent.includes('Endereço'));
            if (!enderecoTable) return null;

            const rows = enderecoTable.querySelectorAll('tbody tr');

            const addresses = [];

            rows.forEach(row => {
                const cells = row.querySelectorAll('td.text-center');
                const address = {
                    'Endereço': cells[0].innerText.trim(),
                    'Número': cells[1].innerText.trim(),
                    'Complemento': cells[2].innerText.trim(),
                    'Bairro': cells[3].innerText.trim(),
                    'Cidade': cells[4].innerText.trim(),
                    'UF': cells[5].innerText.trim(),
                    'CEP': cells[6].innerText.trim()
                };
                addresses.push(address);
            });

            return addresses;
        });

        // Organize os resultados em um objeto JSON
        const jsonResult = {
            "Score": scoreResults,
            "Dados Pessoais": dadosPessoaisResults,
            "Endereço": enderecoResults
        };

        return jsonResult;

    } catch (error) {
        console.log('Error clicking on the image or inserting CPF:', error);
        return null;
    }
}

// Chama checkPage() para iniciar o processo
// ScoreNew()
export { ScoreNew }
