import puppeteer from 'puppeteer';
import { timeout } from 'puppeteer';

async function login(page) {
    // Faz login
    await page.goto('https://newbuscas.tech/Login', {
        waitUntil: 'networkidle2',
        timeout: 0 // Definindo timeout como 0 para desabilitar
    });
    console.log('Navigated to login page');

    await page.type('#username', 'arthurbaldiotti');
    await page.type('#password-input', '10203040');
    console.log('Username and password entered');

    await page.click('.btn-success');
    console.log('Clicked on login button');

    // Aguarda até que a página de login seja completamente carregada
    // await page.waitForNavigation({ waitUntil: 'networkidle2' });
    console.log('Logged in successfully');
}

async function checkPage(cpf) {
    console.log('Start of test.js');
    let browser;
    let page;

    try {
        console.time('Total execution time'); // Inicia o cronômetro

        browser = await puppeteer.launch({
            headless: 'auto',
            args: [
                '--no-sandbox',
                '--disable-setuid-sandbox',
                '--disable-extensions',
                '--clipboard-read', // Permissão para leitura da área de transferência
                '--start-maximized'
            ],
        });
        page = await browser.newPage();

        // Defina permissões para acessar a área de transferência
        const context = browser.defaultBrowserContext();
        await context.overridePermissions('https://newbuscas.tech', ['clipboard-read', 'clipboard-write']);

        await page.setViewport({ width: 1366, height: 768 });
        await page.evaluate(() => {
            document.body.style.zoom = "100%";
        });
        await login(page);
        // Aguarda até que o elemento .callout.callout-success seja encontrado
        await page.waitForSelector('.callout.callout-success', { timeout: 5000 }).catch(() => null);
       const result = await CPFTracker(page);
       return result;
    } catch (error) {
        console.log('Error:', error);
    } finally {
        if (browser) {
            await browser.close();
        }

        console.timeEnd('Total execution time'); // Finaliza o cronômetro e imprime o tempo decorrido
    }
}


async function CPFTracker(page) {
    try {
        // Aguarda até que a imagem seja visível na página
        await page.waitForSelector('img.zoom-image[src="assets/img/big-data.png"]');

        // Localiza a imagem e clica nela
        const image = await page.$('img.zoom-image[src="assets/img/big-data.png"]');
        await image.click();

        // Aguarda até que o campo de CPF seja visível na página e insere o CPF
        await page.waitForSelector('input[name="num"]');
        await page.$eval('input[name="num"]', (element, cpf) => {
            element.value = cpf;
        }, cpf);

        // Aguarda até que o botão de consultar seja visível na página e clica nele
        await page.waitForSelector('button.btn.btn-primary');
        const consultarButton = await page.$('button.btn.btn-primary');
        await consultarButton.click();

        // Aguarda um período suficiente após clicar em Consultar
        await page.waitForTimeout(5000); // Ajuste o tempo conforme necessário

        // Verifica se o elemento de Informações Básicas existe antes de clicar no botão Copiar
        const infoBasicaSelector = 'td.p-1.text-center.fw-bold.fs-3[colspan="4"]';
        const infoBasicaElement = await page.$(infoBasicaSelector);
        if (infoBasicaElement) {
            // Aguarda até que o botão de copiar seja visível na página
            await page.waitForSelector('button#botaoCopiar');

            // Aguarda um curto período após o botão de copiar ser visível
            await page.waitForTimeout(3000); // Ajuste o tempo conforme necessário

            // Clica no botão de copiar
            const botaoCopiar = await page.$('button#botaoCopiar');
            await botaoCopiar.click();

            // Aguarda um período suficiente para garantir que o conteúdo foi copiado para a área de transferência
            await page.waitForTimeout(10000); // Ajuste o tempo conforme necessário

            // Utiliza o Chrome DevTools Protocol para obter o texto copiado diretamente
            const conteudoCopiado = await page.evaluate(() => {
                return navigator.clipboard.readText();
            });

            // Função para extrair os dados de cada seção
            const extrairDados = (conteudo, secao) => {
                const regex = new RegExp(`(${secao})([\\s\\S]*?)(?=(ENDEREÇO|TELEFONE|EMAIL|PARENTES|TELEFONE PARENTES|Sócio EMPRESAS|IMPOSTO DE RENDA|RAIZ TRABALHADOR|$))`, 'g');
                const match = regex.exec(conteudo);
                if (!match) return {};

                const lines = match[2].trim().split(/\n+/);
                const data = {};
                lines.forEach(line => {
                    const [key, ...values] = line.split('\t').map(item => item.trim());
                    const value = values.join(' ');
                    if (key && value) {
                        data[key] = value;
                    }
                });
                return data;
            };

            // Função específica para extrair emails
            const extrairEmails = (conteudo) => {
                const regex = /EMAIL\s*SCORE\s*STATUS([\s\S]*?)(?=(ENDEREÇO|TELEFONE|EMAIL|PARENTES|TELEFONE PARENTES|Sócio EMPRESAS|IMPOSTO DE RENDA|RAIZ TRABALHADOR|$))/g;
                const match = regex.exec(conteudo);
                if (!match) return [];

                const lines = match[1].trim().split(/\n+/);
                const emails = lines.map(line => {
                    const [email, score, status] = line.split('\t').map(item => item.trim());
                    return { email, score, status };
                });

                return emails;
            };

            // Função específica para extrair endereços
            const extrairEnderecos = (conteudo) => {
                const regex = /ENDEREÇO\s*NUM\.\s*COMP\.\s*BAIRRO\s*CIDADE\s*CEP([\s\S]*?)(?=(ENDEREÇO|TELEFONE|EMAIL|PARENTES|TELEFONE PARENTES|Sócio EMPRESAS|IMPOSTO DE RENDA|RAIZ TRABALHADOR|$))/g;
                const match = regex.exec(conteudo);
                if (!match) return [];

                const lines = match[1].trim().split(/\n+/);
                const enderecos = lines.map(line => {
                    const [logradouro, numero, complemento, bairro, cidade, cep] = line.split('\t').map(item => item.trim());
                    return { logradouro, numero, complemento, bairro, cidade, cep };
                });

                return enderecos;
            };

            // Função específica para extrair parentes
            const extrairParentes = (conteudo) => {
                const regex = /PARENTES\s*CONSULTA\s*CPF\s*NOME\s*RELAÇÃO([\s\S]*?)(?=(ENDEREÇO|TELEFONE|EMAIL|PARENTES|TELEFONE PARENTES|Sócio EMPRESAS|IMPOSTO DE RENDA|RAIZ TRABALHADOR|$))/g;
                const match = regex.exec(conteudo);
                if (!match) return [];

                const lines = match[1].trim().split(/\n+/);
                const parentes = lines.map(line => {
                    const [consulta, cpf, nome, relacao] = line.split('\t').map(item => item.trim());
                    return { consulta, cpf, nome, relacao };
                });

                return parentes;
            };

            // Extrair dados de todas as seções principais
            const informacoesBasicas = extrairDados(conteudoCopiado, 'Informações Básicas');
            const endereco = extrairEnderecos(conteudoCopiado);
            const telefone = extrairDados(conteudoCopiado, 'TELEFONE');
            const email = extrairEmails(conteudoCopiado);
            const parentes = extrairParentes(conteudoCopiado);
            const telefoneParentes = extrairDados(conteudoCopiado, 'TELEFONE PARENTES');
            const sociosEmpresas = extrairDados(conteudoCopiado, 'Sócio EMPRESAS');
            const impostoRenda = extrairDados(conteudoCopiado, 'IMPOSTO DE RENDA');
            const raizTrabalhador = extrairDados(conteudoCopiado, 'RAIZ TRABALHADOR');

            // Formatação final dos dados
            const dataFormatada = {
                informacoesBasicas,
                endereco,
                telefone,
                email,
                parentes,
                telefoneParentes,
                sociosEmpresas,
                impostoRenda,
                raizTrabalhador,
            };

            // console.log('Dados extraídos com sucesso:', dataFormatada);
            return dataFormatada;
        } else {
            console.log('Elemento de Informações Básicas não encontrado.');
            return null;
        }

    } catch (error) {
        console.log('Erro ao clicar no botão Consultar ou extrair dados:', error);
        return null;
    }
}










// Chama checkPage() para iniciar o processo
export { checkPage };
// checkPage();
