export class SolverError extends Error {
    constructor(message, locale) {
        super(message);
        this.name = "Solver Error";
    }
    get message() {
        return this.message;
    }
    static from(err, locale) {
        return new SolverError(err, locale);
    }
}
export class NetError extends Error {
    constructor(message, locale) {
        super(message.replace(/[0-9a-z]{32}/, Array(32).fill("*").join("")));
        this.name = "Network Error";
    }
    get message() {
        return this.message;
    }
}
