import time
import re
import sys
import pygetwindow as gw
import pyautogui
from pywinauto import mouse
import requests
import json
import pyperclip
from bs4 import BeautifulSoup


# Receber o CPF como argumento da linha de comando
cpf = sys.argv[1] if len(sys.argv) > 1 else None

if cpf is None:
    print("Por favor, forneça o CPF como argumento da linha de comando.")
    sys.exit(1)

# Iniciar o cronômetro
start_time = time.time()

# Encontrar a janela do Chrome
chrome_window = gw.getWindowsWithTitle("Google Chrome")[0]
# Ativar o foco na janela do Chrome
chrome_window.activate()

# Simular as teclas de atalho para abrir uma nova guia
pyautogui.hotkey('ctrl', 't')
time.sleep(1)

# Simular a digitação da URL na barra de endereço do Chrome
pyautogui.write("https://maxbuscas.info/bases/38", interval=0.05)
pyautogui.press('enter')
time.sleep(1.5)

# Ativar a janela do Chrome
chrome_window.activate()
time.sleep(1)
# Simular a digitação do CPF
pyautogui.write(cpf)
time.sleep(2)

# Localizar e clicar no botão de verificação do captcha
# x_captcha, y_captcha = 796, 423
# mouse.click(coords=(x_captcha, y_captcha))
time.sleep(11)

# Localizar e clicar no botão de consulta
x_consulta, y_consulta = 831, 546
mouse.click(coords=(x_consulta, y_consulta))
time.sleep(5)

# Pressiona a combinação de teclas para selecionar todo o texto no console do DevTools (Ctrl + A)
pyautogui.hotkey('ctrl', 'shift', 'i')
time.sleep(2)
coordenadas_botao_showmore = (1107, 609)
coordenadas_botao_selecionar = (1174, 609)
pyautogui.click(*coordenadas_botao_showmore)
pyautogui.click(*coordenadas_botao_selecionar)
pyautogui.hotkey('ctrl', 'a')

# Copia o texto selecionado para a área de transferência (Ctrl + C)
pyautogui.hotkey('ctrl', 'c')

# Obtém o texto copiado da área de transferência usando pyperclip
texto_copiado = pyperclip.paste()

# Fecha o DevTools (Ctrl + Shift + I novamente para fechá-lo)
pyautogui.hotkey('ctrl', 'shift', 'i')

# Função para processar os dados copiados e convertê-los em JSON
from bs4 import BeautifulSoup
import json

def processar_dados(texto):
    soup = BeautifulSoup(texto, "html.parser")

    # Encontrar a tabela de dados básicos
    tabela_dados_basicos = soup.find('table', class_='table-striped')

    if tabela_dados_basicos:
        linhas = tabela_dados_basicos.find_all('tr')

        dados_basicos = {
            "Nome do Cliente": "",
            "CPF/CNPJ": "",
            "Código do Correspondente": "UniConsultas",
            "Data / Hora": ""
        }

        for linha in linhas:
            colunas = linha.find_all('td')
            
            if len(colunas) == 2:
                titulo = colunas[0].get_text(strip=True)
                valor = colunas[1].get_text(strip=True)
                
                if "Nome do Cliente:" in titulo:
                    dados_basicos["Nome do Cliente"] = valor
                elif "CPF/CNPJ:" in titulo:
                    dados_basicos["CPF/CNPJ"] = valor
                elif "Código do Correspondente:" in titulo:
                    dados_basicos["Código do Correspondente"] = "UniConsultas"
                elif "Data / Hora:" in titulo:
                    dados_basicos["Data / Hora"] = valor

        cadin = {
            "Sequencia": [],
            "Registros": []
        }

        pendencias = []
        scpc = []
        protestos = []

        secao_atual = None
        registro_atual = None

        # Processar as outras seções conforme o código original
        for td in soup.find_all('td'):
            texto = td.get_text(strip=True)

            if "DADOS BASICOS" in texto:
                secao_atual = "DADOS BASICOS"
                continue
            elif "CADIN" in texto:
                secao_atual = "CADIN"
                continue
            elif "Pendências REFIN/PEFIN" in texto:
                secao_atual = "Pendências REFIN/PEFIN"
                continue
            elif "SCPC" in texto:
                secao_atual = "SCPC"
                continue
            elif "SICCF" in texto:
                secao_atual = "SICCF"
                continue
            elif "SINAD: Restrição CAIXA" in texto:
                secao_atual = "SINAD"
                continue
            elif "Cheque sem Fundos" in texto:
                secao_atual = "Cheque sem Fundos"
                continue
            elif "Protesto" in texto:
                secao_atual = "Protesto"
                continue
            elif "SICOW" in texto:
                secao_atual = "SICOW"
                continue

            if secao_atual == "CADIN":
                if "Até 30 dias Contratos em atraso" in texto or "Após 30 dias Contratos em atraso" in texto:
                    cadin["Sequencia"].append(texto)
                elif registro_atual is None:
                    registro_atual = {"Sequencia": len(cadin["Registros"]) + 1}
                else:
                    if "Sigla Credor" not in registro_atual:
                        registro_atual["Sigla Credor"] = texto
                    elif "Nome Credor" not in registro_atual:
                        registro_atual["Nome Credor"] = texto
                    elif "Data Primeira Ocorrência" not in registro_atual:
                        registro_atual["Data Primeira Ocorrencia"] = texto
                    elif "Data Última Ocorrência" not in registro_atual:
                        registro_atual["Data Ultima Ocorrencia"] = texto
                    elif "Quantidade Ocorrências" not in registro_atual:
                        registro_atual["Quantidade Ocorrencias"] = texto
                        cadin["Registros"].append(registro_atual)
                        registro_atual = None
            
            elif secao_atual == "Pendências REFIN/PEFIN":
                if registro_atual is None:
                    registro_atual = {}
                else:
                    if "Data" not in registro_atual:
                        registro_atual["Data"] = texto
                    elif "Tipo Financ." not in registro_atual:
                        registro_atual["Tipo Financ."] = texto
                    elif "Aval" not in registro_atual:
                        registro_atual["Aval"] = texto
                    elif "Valor (R$)" not in registro_atual:
                        registro_atual["Valor (R$)"] = texto
                    elif "Contrato" not in registro_atual:
                        registro_atual["Contrato"] = texto
                    elif "Origem" not in registro_atual:
                        registro_atual["Origem"] = texto
                    elif "Cidade" not in registro_atual:
                        registro_atual["Cidade"] = texto
                        pendencias.append(registro_atual)
                        registro_atual = None
            
            elif secao_atual == "SCPC":
                if registro_atual is None:
                    registro_atual = {}
                else:
                    if "Dt Ocorr" not in registro_atual:
                        registro_atual["Dt Ocorr"] = texto
                    elif "Tp Devedor" not in registro_atual:
                        registro_atual["Tp Devedor"] = texto
                    elif "Nome" not in registro_atual:
                        registro_atual["Nome"] = texto
                    elif "Vr Divida" not in registro_atual:
                        registro_atual["Vr Divida"] = texto
                    elif "Cidade" not in registro_atual:
                        registro_atual["Cidade"] = texto
                    elif "UF" not in registro_atual:
                        registro_atual["UF"] = texto
                    elif "Contrato" not in registro_atual:
                        registro_atual["Contrato"] = texto
                    elif "Dt Disp" not in registro_atual:
                        registro_atual["Dt Disp"] = texto
                        scpc.append(registro_atual)
                        registro_atual = None

            elif secao_atual == "Protesto":
                if registro_atual is None:
                    registro_atual = {}
                else:
                    if "Data" not in registro_atual:
                        registro_atual["Data"] = texto
                    elif "Valor Protesto" not in registro_atual:
                        registro_atual["Valor Protesto"] = texto
                    elif "Cartorio" not in registro_atual:
                        registro_atual["Cartorio"] = texto
                    elif "Cidade" not in registro_atual:
                        registro_atual["Cidade"] = texto
                    elif "UF" not in registro_atual:
                        registro_atual["UF"] = texto
                        protestos.append(registro_atual)
                        registro_atual = None

        dados_final = {
            "DADOS BASICOS": dados_basicos,
            "CADIN": cadin,
            "Pendências REFIN/PEFIN": pendencias,
            "SCPC": scpc,
            "Protesto": protestos,
        }

        print(json.dumps(dados_final, indent=4))

    else:
        print("Tabela de dados básicos não encontrada.")

if texto_copiado:
    processar_dados(texto_copiado)
else:
    print("Nenhum texto encontrado na área de transferência.")


# Parar o cronômetro e calcular o tempo total
end_time = time.time()
total_time = end_time - start_time

# Imprimir o tempo total no console
# print("Tempo total de execução:", total_time, "segundos")
