from selenium import webdriver
from selenium.webdriver.common.by import By
from selenium.webdriver.support.ui import WebDriverWait
from selenium.webdriver.support import expected_conditions as EC
from bs4 import BeautifulSoup
import re
import json

# Função para limpar espaços em branco excessivos e caracteres de tabulação
def clean_text(text):
    return re.sub(r'\s+', ' ', text).strip()

# Configurações para o WebDriver do Chrome (é necessário ter o ChromeDriver instalado)
options = webdriver.ChromeOptions()
options.add_argument('--headless')  # Executar o navegador em modo headless (sem interface gráfica)

# Iniciar o navegador
driver = webdriver.Chrome(options=options)
driver.get('https://api.searchlock.me/dividas_master?tipo=cpf&token=eDRFTvybunIMOnibuYVGTCFXcf&cpf=32676277880')

try:
    # Aguardar até que o iframe esteja presente na página
    iframe = WebDriverWait(driver, 10).until(
        EC.presence_of_element_located((By.TAG_NAME, 'iframe'))
    )
    
    # Mudar para o contexto do iframe
    driver.switch_to.frame(iframe)

    # Esperar até que o botão 'Copiar Resultado' esteja clicável
    copy_button = WebDriverWait(driver, 10).until(
        EC.element_to_be_clickable((By.XPATH, "//button[contains(text(), 'Copiar Resultado')]"))
    )
    
    # Clicar no botão 'Copiar Resultado'
    copy_button.click()

    # Aguardar um momento para que o conteúdo seja copiado
    driver.implicitly_wait(2)  # Esperar 2 segundos

    # Obter o conteúdo copiado da área de transferência
    clipboard_content = driver.execute_script("return navigator.clipboard.readText();")

    # Processar o conteúdo copiado (converter de JSON para estrutura de dados Python)
    data = json.loads(clipboard_content)

    # Extrair e imprimir os dados desejados
    nome_cliente = clean_text(data.get('nome_cliente', ''))
    cpf_cnpj = clean_text(data.get('cpf_cnpj', ''))
    nome_mae = clean_text(data.get('nome_mae', ''))
    data_nascimento = clean_text(data.get('data_nascimento', ''))
    
    print(f"Nome do Cliente: {nome_cliente}")
    print(f"CPF/CNPJ: {cpf_cnpj}")
    print(f"Nome da Mãe: {nome_mae}")
    print(f"Data de Nascimento: {data_nascimento}")

finally:
    driver.quit()  # Fechar o navegador ao finalizar

