import express from 'express';
import https from 'https';
import fs from 'fs'; // Importe o módulo 'fs' para ler o certificado SSL
import axios from 'axios';
import { checkPage } from '../commands/apicpftop.js';
import { checkScore } from '../commands/score.js';
import { ScoreNew } from '../commands/scorenew.js';
import { CheckJuridica } from '../commands/juridica.js';
import { FotoCPF } from '../commands/foto.js';
import { BuscaSix } from '../commands/testbuscasix.js'
import { BuscaSix2 } from '../commands/buscasixconta2.js';
import { connectToDatabase, connection } from './connect.js';
import { decrementAndReorderConsults } from './decrementconsultas.js';
import { v4 as uuidv4 } from 'uuid';
import bodyParser from 'body-parser';
import cors from 'cors';
import { exec } from 'child_process';
import path from 'path';
import cheerio from 'cheerio';


const app = express();
app.use(bodyParser.json());
app.use(cors());

// SISTEMA DE STATUS INACTIVE PARA ACTIVE TODAS AS MEIA-NOITE DE CADA DIA!!
const accountsFilePath = 'C:\\xampp\\htdocs\\account\\accounts.json'; // Caminho completo para o arquivo accounts.json

// Função para ler e atualizar o arquivo accounts.json
function updateAccountsStatus() {
    try {
        // Ler o arquivo accounts.json
        const accountsData = fs.readFileSync(accountsFilePath, 'utf8');
        const accounts = JSON.parse(accountsData);

        // Verificar cada usuário e alterar o status para "active" se estiver "inactive"
        accounts.users.forEach(user => {
            if (user.status === 'inactive') {
                user.status = 'active';
            }
        });

        // Escrever de volta ao arquivo accounts.json
        fs.writeFileSync(accountsFilePath, JSON.stringify(accounts, null, 2));
        
        console.log('Status dos usuários atualizado com sucesso.');
    } catch (error) {
        console.error('Erro ao atualizar o status dos usuários:', error);
    }
}

// Função para obter o horário atual em um fuso horário específico
function getCurrentTime(timezone) {
    const options = {
        timeZone: timezone,
        hour: 'numeric',
        minute: 'numeric'
    };
    const formatter = new Intl.DateTimeFormat([], options);
    return formatter.format(new Date());
}

// Agendar a execução da função todos os dias às 00:00 no fuso horário desejado
function scheduleDailyUpdate() {
    const desiredTimeZone = 'America/Sao_Paulo'; // Altere conforme necessário
    
    // Obter o tempo atual no fuso horário desejado
    const currentTime = getCurrentTime(desiredTimeZone);
    console.log(`Horário atual em ${desiredTimeZone}: ${currentTime}`);

    // Calcular o tempo até a meia-noite no fuso horário desejado
    const now = new Date();
    const midnight = new Date(now.getFullYear(), now.getMonth(), now.getDate() + 1, 0, 0, 0, 0);
    const timeUntilMidnight = midnight - now;

    // Agendar a execução da função updateAccountsStatus no horário de meia-noite todos os dias
    setTimeout(function() {
        updateAccountsStatus();
        setInterval(updateAccountsStatus, 24 * 60 * 60 * 1000); // Repetir a cada 24 horas
    }, timeUntilMidnight);
}

// Iniciar o agendamento
scheduleDailyUpdate();

// FINALIZAÇÃO HORÁRIO MEIA NOITE SISTEMA



// Configuração do Sistema de Segurança | Matheus Alves

// Middleware para verificar o token enviado na URL
const verifyTokenFromUrl = async (req, res, next) => {
    const token = req.params.token; // Captura o token enviado como parte da URL

    if (!token) {
        return res.status(401).json({ message: 'Token não fornecido. Acesso não autorizado.' });
    }

    try {
        const connection = await connectToDatabase();
        
        connection.query('SELECT token FROM tokens WHERE token = ?', [token], async (error, results) => {
            if (error) {
                console.error('Erro ao consultar o banco de dados:', error);
                return res.status(500).json({ error: 'Erro ao consultar o banco de dados' });
            }

            if (results.length === 0) {
                return res.status(404).json({ error: 'Token inválido. Acesso não autorizado.' });
            }

              req.tokenInfo = results[0];
        next();
        });
    } catch (error) {
        console.error('Erro ao conectar ao banco de dados:', error);
        res.status(500).json({ error: 'Erro ao verificar o token.' });
    }
};

// Fim da Configuração do Sistema de Segurança | Matheus Alves

app.post('/:token/uni-register-access', verifyTokenFromUrl, async (req, res) => {
    const { email, cpf } = req.body;

    // Verifica se email e cpf foram fornecidos
    if (!email || !cpf) {
        return res.status(400).json({ message: 'Email e CPF são obrigatórios para realizar o registro.' });
    }

    try {
        await connectToDatabase();

        // Se não encontrou registros duplicados, procede com a inserção
        const token = uuidv4();
        const today = new Date();
        const day = String(today.getDate()).padStart(2, '0');
        const month = String(today.getMonth() + 1).padStart(2, '0');
        const year = today.getFullYear();
        const dataRegistro = `${day}/${month}/${year}`;
        const status = 1;

        const insertQuery = 'INSERT INTO tokens (email, cpf, dataregistro, token, status) VALUES (?, ?, ?, ?, ?)';
        const insertValues = [email, cpf, dataRegistro, token, status];

        await connection.execute(insertQuery, insertValues);
        return res.status(201).json({ message: 'Usuário registrado com sucesso, e o acesso foi liberado.', token });
    } catch (error) {
        console.error('Erro ao processar requisição:', error);
        return res.status(500).json({ message: 'Erro no servidor interno, consulte o suporte técnico.' });
    }
});

// Rota para Consulta de API Financeiro Externo

app.get('/:token/divida-master/:cpf', verifyTokenFromUrl, async (req, res) => {
    try {
        const cpf = req.params.cpf;
        const url = `https://api.searchlock.me/dividas_master?tipo=cpf&token=eDRFTvybunIMOnibuYVGTCFXcf&cpf=${cpf}`;
        const response = await fetch(url);
        const html = await response.text();

        // Carrega o HTML usando Cheerio
        const $ = cheerio.load(html);

        // Encontra o conteúdo do iframe a partir do atributo srcdoc
        const iframeContent = $('#result-iframe').attr('srcdoc');

        if (!iframeContent) {
            throw new Error('Conteúdo do iframe não encontrado no HTML');
        }

        // Carrega o conteúdo do iframe no Cheerio para extração dos dados
        const $iframe = cheerio.load(iframeContent);

        // Extraímos o texto completo do iframe
        const fullText = $iframe('body').text();

        // Retorna o texto completo como resposta
        res.json({ content: fullText });

    } catch (error) {
        console.error('Erro ao consultar CPF:', error);
        res.status(500).json({ error: 'Erro ao consultar CPF. Por favor, tente novamente.' });
    }
});

// FIM da Rota para Consulta de API Financeiro Externo.

// Rota para a consulta do CPF
app.get('/:token/consultatop/:cpf', verifyTokenFromUrl, async (req, res) => {
    const cpf = req.params.cpf;
    const result = await checkPage(cpf); // Chama a função checkPage com o CPF recebido
    
    // Verifica se o resultado não é nulo, vazio ou undefined antes de enviar
    if (result !== null && result !== undefined && Object.keys(result).length !== 0) {
        res.json(result); // Envia o resultado como uma resposta JSON
    } else {
        res.status(404).json({ error: 'CPF not found' }); // Retorna um erro se o resultado for nulo, vazio ou undefined
    }
});

app.get('/:token/consultascore/:cpf', verifyTokenFromUrl, async (req, res) => {
    const cpf = req.params.cpf;
    const result = await checkScore(cpf); // Chama a função checkPage com o CPF recebido
    
    // Verifica se o resultado não é nulo, vazio ou undefined antes de enviar
    if (result !== null && result !== undefined && Object.keys(result).length !== 0) {
        res.json(result); // Envia o resultado como uma resposta JSON
    } else {
        res.status(404).json({ error: 'CPF not found' }); // Retorna um erro se o resultado for nulo, vazio ou undefined
    }
});

app.get('/:token/nb-consultascore/:cpf', verifyTokenFromUrl, async (req, res) => {
    const cpf = req.params.cpf;
    const result = await ScoreNew(cpf); // Chama a função checkPage com o CPF recebido
    
    // Verifica se o resultado não é nulo, vazio ou undefined antes de enviar
    if (result !== null && result !== undefined && Object.keys(result).length !== 0) {
        res.json(result); // Envia o resultado como uma resposta JSON
    } else {
        res.status(404).json({ error: 'CPF not found' }); // Retorna um erro se o resultado for nulo, vazio ou undefined
    }
});

app.get('/:token/nb-consultafoto/:cpf', verifyTokenFromUrl, async (req, res) => {
    const cpf = req.params.cpf;
    const result = await FotoCPF(cpf); // Chama a função checkPage com o CPF recebido
    
    // Verifica se o resultado não é nulo, vazio ou undefined antes de enviar
    if (result !== null && result !== undefined && Object.keys(result).length !== 0) {
        res.json(result); // Envia o resultado como uma resposta JSON
    } else {
        res.status(404).json({ error: 'CPF não existe ou não foi encontrado nenhuma foto registrada no banco de dados.' }); // Retorna um erro se o resultado for nulo, vazio ou undefined
    }
});

app.get('/:token/consultacpfdividas/:cpf', verifyTokenFromUrl, async (req, res) => {
    const cpf = req.params.cpf;
    const result = await BuscaSix(cpf); // Chama a função checkPage com o CPF recebido
    
    // Verifica se o resultado não é nulo, vazio ou undefined antes de enviar
    if (result !== null && result !== undefined && Object.keys(result).length !== 0) {
        res.json(result); // Envia o resultado como uma resposta JSON
    } else {
        res.status(404).json({ error: 'CPF não existe ou não foi encontrado nenhuma foto registrada no banco de dados.' }); // Retorna um erro se o resultado for nulo, vazio ou undefined
    }
});

// Fila de requisições
const queue = [];
let isProcessing = false;

// URLs das APIs das máquinas
const rainhaAPI = 'http://104.234.224.190:3000/3406bddf-8759-404e-bd3f-a4261a6c6ce6/mx-consultafinanceira';
const escrava1API = 'http://104.234.224.187:3000/3406bddf-8759-404e-bd3f-a4261a6c6ce6/mx-consultafinanceira2';
const escrava2API = 'http://104.234.224.188:3000/3406bddf-8759-404e-bd3f-a4261a6c6ce6/mx-consultafinanceira2';

// Função para processar a fila de requisições
const processRequest = async (req, res) => {
    const cpf = req.params.cpf;

    try {
        let response;
        let data;

        // Enviar a requisição para a máquina rainha
        response = await fetch(`${rainhaAPI}/${cpf}`);
        data = await response.json();

        // Verificar se 'DADOS BASICOS' está vazio
        const dadosBasicosIsEmpty = !data || !data['DADOS BASICOS'] || Object.keys(data['DADOS BASICOS']).length === 0;

        // Se a máquina rainha estiver ocupada ou 'DADOS BASICOS' estiver vazio, tentar enviar para uma das escravas
        if (response.status === 503 || (data && data.error === 'Máquina ocupada') || dadosBasicosIsEmpty) {
            const randomIndex = Math.random() < 0.5 ? 0 : 1;
            const escravaAPI = randomIndex === 0 ? escrava1API : escrava2API;

            response = await fetch(`${escravaAPI}?cpf=${cpf}`);
            data = await response.json();

            // Verificar novamente se 'DADOS BASICOS' está vazio após a chamada da escrava
            if (!data || !data['DADOS BASICOS'] || Object.keys(data['DADOS BASICOS']).length === 0) {
                throw new Error('Dados básicos estão vazios mesmo após tentativa com escrava.');
            }
        }

        // Processar a requisição com sucesso
        res.json(data);

        // Verificar se deve chamar decrementAndReorderConsults()
        if (data['DADOS BASICOS'] && Object.keys(data['DADOS BASICOS']).length > 0) {
            if (data.error !== 'Tivemos um problema interno no nosso servidor, tente novamente em um minuto.') {
                res.status(500).json({ error: 'Erro ao processar requisição' });
            } else {
                console.log('Não foi decrementado uma consulta na conta atual.');
            }
        }

    } catch (error) {
        console.error(`Erro ao processar requisição: ${error.message}`);
        res.status(500).json({ error: 'Erro ao processar requisição' });
    } finally {
        // Marca como não processando para permitir novas requisições
        isProcessing = false;
    }
};
// Rota para enfileirar a requisição
app.get('/:token/mx-consultafinanceira2/:cpf', verifyTokenFromUrl, (req, res) => {
    if (isProcessing) {
        return res.status(503).json({ error: 'Máquina ocupada. Aguarde.' });
    }
    isProcessing = true;
    // Não envia a resposta imediatamente, pois será tratada pelo processQueue
    processRequest(req, res);
});

// Rota para processar a requisição localmente
app.get('/:token/mx-consultafinanceira/:cpf', verifyTokenFromUrl, async (req, res) => {
    const cpf = req.params.cpf;

    // Use cmd.exe como shell
    exec(`python C:\\Users\\Administrator\\Desktop\\Arthur-KingBuscas\\src\\api\\maxbuscas\\maxbusca.py ${cpf}`, (error, stdout, stderr) => {
        if (error) {
            console.error(`Erro ao executar o script Python local: ${error.message}`);
            return res.status(500).json({ error: 'Erro interno do servidor' });
        }
        if (stderr) {
            console.error(`Erro de script Python local: ${stderr}`);
            return res.status(500).json({ error: 'Erro interno do servidor' });
        }

        try {
            // Substitui caracteres inválidos antes de fazer o parse
            const cleanedStdout = stdout.replace(/[\r\n]/g, '').replace(/'/g, '"').replace(/�/g, 'ç');
            const data = JSON.parse(cleanedStdout);
            // console.log(data);
            res.json(data); // Retorna os dados processados localmente
        } catch (parseError) {
            console.error(`Erro ao analisar JSON: ${parseError.message}`);
            return res.status(500).json({ error: 'Tivemos um problema interno no nosso servidor, tente novamente em um minuto.' });
        }
    });
});



app.get('/:token/consultacpfdividas2/:cpf', verifyTokenFromUrl, async (req, res) => {
    const cpf = req.params.cpf;
    const result = await BuscaSix2(cpf); // Chama a função checkPage com o CPF recebido
    
    // Verifica se o resultado não é nulo, vazio ou undefined antes de enviar
    if (result !== null && result !== undefined && Object.keys(result).length !== 0) {
        res.json(result); // Envia o resultado como uma resposta JSON
    } else {
        res.status(404).json({ error: 'CPF não existe ou não foi encontrado nenhuma foto registrada no banco de dados.' }); // Retorna um erro se o resultado for nulo, vazio ou undefined
    }
});

app.post('/registeruniconsultas', async (req, res) => {
    const { name, sobrenome, email, telefone, password } = req.body;
    const today = new Date();
    const day = String(today.getDate()).padStart(2, '0'); 
    const month = String(today.getMonth() + 1).padStart(2, '0');
    const year = today.getFullYear();
    const formattedDate = `${day}/${month}/${year}`;
    // Verifica se todos os campos obrigatórios foram recebidos
    if (!name || !sobrenome || !email || !telefone || !password) {
      return res.status(400).json({ error: 'Por favor, forneça todos os campos necessários.' });
    }
  
    try {
      // Estabelecer conexão com o banco de dados
      const connection = await connectToDatabase();
      
      // Verifica se já existe um usuário com o mesmo email ou telefone
      const checkUserQuery = 'SELECT * FROM users WHERE email = ? OR telefone = ?';
      connection.query(checkUserQuery, [email, telefone], (error, results, fields) => {
        if (error) {
          console.error('Erro ao verificar dados no banco de dados:', error);
          return res.status(500).json({ error: 'Erro ao registrar. Tente novamente mais tarde.' });
        }
        if (results.length > 0) {
          // Se já existir um usuário com o mesmo email ou telefone, retorna erro
          return res.status(400).json({ error: 'Já existe um usuário registrado com esses dados.' });
        }
        
        // Executa a inserção dos dados no banco de dados
        const insertUserQuery = `INSERT INTO users (nome, sobrenome, email, telefone, password, creditos, dataregistro, status) VALUES (?, ?, ?, ?, ?, 0, ?, 1)`;
        connection.query(insertUserQuery, [name, sobrenome, email, telefone, password, formattedDate], (insertError, insertResults, insertFields) => {
          if (insertError) {
            console.error('Erro ao inserir dados no banco de dados:', insertError);
            return res.status(500).json({ error: 'Erro ao registrar. Tente novamente mais tarde.' });
          }
          console.log('Registro inserido com sucesso no banco de dados:', insertResults);
          res.status(201).json({ message: 'Registro realizado com sucesso!' });
        });
      });
    } catch (error) {
      console.error('Erro ao conectar ao banco de dados:', error);
      res.status(500).json({ error: 'Erro ao conectar ao banco de dados. Tente novamente mais tarde.' });
    }
});

app.post('/loginuniconsultas', async (req, res) => {
    const { email, password } = req.body;

    try {
        // Estabelecer conexão com o banco de dados
        const connection = await connectToDatabase();
        
        // Verifica se o usuário existe com o email fornecido e se a senha está correta
        const query = 'SELECT * FROM users WHERE email = ? AND password = ?';
        connection.query(query, [email, password], (error, results, fields) => {
            if (error) {
                console.error('Erro ao verificar dados no banco de dados:', error);
                return res.status(500).json({ error: 'Erro ao fazer login. Tente novamente mais tarde.' });
            }
            if (results.length === 0) {
                // Se não houver usuário com o email fornecido ou a senha estiver incorreta, retorna erro
                return res.status(401).json({ error: 'Credenciais inválidas.' });
            }
            
            // Se as credenciais estiverem corretas, retorna os detalhes do usuário
            const user = results[0];
            res.status(200).json(user);
        });
    } catch (error) {
        console.error('Erro ao conectar ao banco de dados:', error);
        res.status(500).json({ error: 'Erro ao conectar ao banco de dados. Tente novamente mais tarde.' });
    }
});

app.post('/:token/register/api/credits', verifyTokenFromUrl, async (req, res) => {
    try {
        const connection = await connectToDatabase();
        
        const { telefone, creditos } = req.body;

        // Validar se todos os campos necessários foram fornecidos
        if (!telefone || creditos === undefined) {
            return res.status(400).json({ error: 'Todos os campos são obrigatórios' });
        }

        // Verificar se o email existe na tabela de usuários
        connection.query('SELECT creditos FROM users WHERE telefone = ?', [telefone], async (error, results) => {
            if (error) {
                console.error('Erro ao consultar o banco de dados:', error);
                return res.status(500).json({ error: 'Erro ao consultar o banco de dados' });
            }

            if (results.length === 0) {
                return res.status(404).json({ error: 'Telefone não encontrado' });
            }

            const currentCredits = parseInt(results[0].creditos || '0'); // Valor atual de créditos

            // Calcular novos créditos
            const newCredits = currentCredits + parseInt(creditos);

            // Atualizar a quantidade de créditos na tabela de usuários
            connection.query('UPDATE users SET creditos = ? WHERE telefone = ?', [newCredits, telefone], async (error, results) => {
                if (error) {
                    console.error('Erro ao atualizar créditos:', error);
                    return res.status(500).json({ error: 'Erro ao atualizar créditos' });
                }

                res.status(200).json({ message: 'Créditos adicionados com sucesso' });
            });
        });
    } catch (error) {
        console.error('Erro ao conectar ao banco de dados:', error);
        res.status(500).json({ error: 'Erro ao conectar ao banco de dados' });
    }
});

app.post('/:token/select/api/credits', verifyTokenFromUrl, async (req, res) => {
    try {
        const connection = await connectToDatabase();
        
        const { telefone } = req.body;

        // Validar se todos os campos necessários foram fornecidos
        if (!telefone) {
            return res.status(400).json({ error: 'O campo telefone é obrigatório' });
        }

        // Verificar se o telefone existe na tabela de usuários
        connection.query('SELECT creditos FROM users WHERE telefone = ?', [telefone], async (error, results) => {
            if (error) {
                console.error('Erro ao consultar o banco de dados:', error);
                return res.status(500).json({ error: 'Erro ao consultar o banco de dados' });
            }

            if (results.length === 0) {
                return res.status(404).json({ error: 'Telefone não encontrado' });
            }

            const currentCredits = parseInt(results[0].creditos || '0'); // Valor atual de créditos

            res.status(200).json({ creditos: currentCredits });
        });
    } catch (error) {
        console.error('Erro ao conectar ao banco de dados:', error);
        res.status(500).json({ error: 'Erro ao conectar ao banco de dados' });
    }
});

// SISTEMA DE NOTIFICAÇÕES DASHBOARD
app.post('/:token/register/api/notifications', verifyTokenFromUrl, async (req, res) => {
    try {
      const connection = await connectToDatabase();
      
      const { foto, titulo, descricao, dataregistro } = req.body;
  
      // Validar se todos os campos necessários foram fornecidos
      if (!foto || !titulo || !descricao || !dataregistro) {
        return res.status(400).json({ error: 'Todos os campos são obrigatórios' });
      }
  
      // Inserir notificação no banco de dados
      connection.query('INSERT INTO notifications (foto, titulo, descricao, dataregistro) VALUES (?, ?, ?, ?)', 
        [foto, titulo, descricao, dataregistro], 
        (error, results) => {
          if (error) {
            console.error('Erro ao inserir notificação:', error);
            res.status(500).json({ error: 'Erro ao inserir notificação' });
          } else {
            res.status(201).json({ message: 'Notificação inserida com sucesso' });
          }
        }
      );
    } catch (error) {
      console.error('Erro ao conectar ao banco de dados:', error);
      res.status(500).json({ error: 'Erro ao conectar ao banco de dados' });
    }
  });
  
app.get(':token/select/api/notifications', verifyTokenFromUrl, async (req, res) => {
    try {
      const connection = await connectToDatabase();
  
      connection.query('SELECT * FROM notifications ORDER BY dataregistro DESC LIMIT 10', (error, results) => {
        if (error) {
          console.error('Erro ao obter notificações:', error);
          res.status(500).json({ error: 'Erro ao obter notificações' });
        } else {
          res.status(200).json(results);
        }
      });
    } catch (error) {
      console.error('Erro ao conectar ao banco de dados:', error);
      res.status(500).json({ error: 'Erro ao conectar ao banco de dados' });
    }
  });
//   API SISTEMA NOTIFICAÇÕES DASHBOARD

app.get('/:token/api/consulta-cpfexterna/', verifyTokenFromUrl, async (req, res) => {
    try {
      const { cpf } = req.query;
      const url = `https://api.searchlock.me/evodata?token=eDRFTvybunIMOnibuYVGTCFXcf&tipo=cpf&dados=${cpf}`;
  
      const response = await fetch(url);
      const data = await response.json();
  
      res.json(data);
    //   console.log(data);
    } catch (error) {
      console.error('Erro ao consultar CPF:', error);
      res.status(500).json({ error: 'Erro ao consultar CPF. Por favor, tente novamente.' });
    }
  });


app.get('/:token/api/consulta-financeiraexterna', verifyTokenFromUrl, async (req, res) => {
    try {
      const { cpf } = req.query;
      const url = `https://api.searchlock.me/sbr?tipo=cpf&token=eDRFTvybunIMOnibuYVGTCFXcf&data=${cpf}`;
  
      const response = await fetch(url);
      const data = await response.json();
  
      res.json(data);
    } catch (error) {
      console.error('Erro ao consultar CPF:', error);
      res.status(500).json({ error: 'Erro ao consultar CPF. Por favor, tente novamente.' });
    }
  });

  app.get('/:token/api/consulta-cepexterna', verifyTokenFromUrl, async (req, res) => {
    try {
      const { cep } = req.query;
      const url = `http://api.searchlock.me/evodataCeps?token=eDRFTvybunIMOnibuYVGTCFXcf&tipo=cep&dados=${cep}`;
      const response = await fetch(url);
      const data = await response.json();
  
      res.json(data);
    } catch (error) {
      console.error('Erro ao consultar CPF:', error);
      res.status(500).json({ error: 'Erro ao consultar CPF. Por favor, tente novamente.' });
    }
  });

  app.get('/:token/api/consulta-emailexterna', verifyTokenFromUrl, async (req, res) => {
    try {
      const { email } = req.query;
      const url = `http://api.searchlock.me/evodataEmails?token=eDRFTvybunIMOnibuYVGTCFXcf&tipo=email&dados=${email}`;
    //   console.log(email);
      const response = await fetch(url);
      const data = await response.json();
  
      res.json(data);
    } catch (error) {
      console.error('Erro ao consultar CPF:', error);
      res.status(500).json({ error: 'Erro ao consultar CPF. Por favor, tente novamente.' });
    }
  });

  app.get('/:token/api/consulta-telefoneexterna', verifyTokenFromUrl, async (req, res) => {
    try {
      const { telefone } = req.query;
      const url = `https://api.searchlock.me/credilink?token=eDRFTvybunIMOnibuYVGTCFXcf&tipo=telefone&telefone=${telefone}`;
      const response = await fetch(url);
      const data = await response.json();
      console.log(data);
  
      res.json(data);
    } catch (error) {
      console.error('Erro ao consultar CPF:', error);
      res.status(500).json({ error: 'Erro ao consultar CPF. Por favor, tente novamente.' });
    }
  });


  app.post('/:token/api/retirarcreditos', verifyTokenFromUrl, async (req, res) => {
    try {
        const { email } = req.query;
        console.log(email);

        // Verifica se há créditos disponíveis para o usuário
        const [creditResult] = await connection.promise().query("SELECT creditos FROM users WHERE email = ?", [email]);
        const availableCredits = creditResult[0].creditos;

        if (availableCredits <= 0) {
            return res.status(400).json({ success: false, error: "Não há créditos disponíveis para retirar." });
        }

        // Decrementa os créditos se houver disponibilidade
        const [results] = await connection.promise().query("UPDATE users SET creditos = creditos - 1 WHERE email = ?", [email]);

        if (results.affectedRows === 0) {
            return res.status(404).json({ success: false, error: "Usuário não encontrado." });
        }

        return res.json({ success: true });
    } catch (error) {
        console.error("Erro ao decrementar créditos:", error);
        console.log(error);
        return res.status(500).json({ success: false, error: "Erro interno do servidor." });
    }
});

app.post('/:token/register/retirarcredits', verifyTokenFromUrl, async (req, res) => {
    try {
        const { telefone, creditos } = req.body;

        // Verifica se há créditos disponíveis para o usuário
        const [creditResult] = await connection.promise().query("SELECT creditos FROM users WHERE telefone = ?", [telefone]);
        const availableCredits = creditResult[0].creditos;

        if (availableCredits < creditos) {
            return res.status(400).json({ success: false, error: "Não há créditos suficientes para retirar." });
        }

        // Decrementa os créditos pelo valor especificado
        const [results] = await connection.promise().query("UPDATE users SET creditos = creditos - ? WHERE telefone = ?", [creditos, telefone]);

        if (results.affectedRows === 0) {
            return res.status(404).json({ success: false, error: "Usuário não encontrado." });
        }

        return res.json({ success: true });
    } catch (error) {
        console.error("Erro ao decrementar créditos:", error);
        console.log(error);
        return res.status(500).json({ success: false, error: "Erro interno do servidor." });
    }
});



app.get('/:token/consultadividaapi/:cpf', verifyTokenFromUrl, async (req, res) => {
    const cpf = req.params.cpf;
    const result = await BuscaSix2(cpf); // Chama a função checkPage com o CPF recebido
    
    // Verifica se o resultado não é nulo, vazio ou undefined antes de enviar
    if (result !== null && result !== undefined && Object.keys(result).length !== 0) {
        res.json(result); // Envia o resultado como uma resposta JSON
    } else {
        res.status(404).json({ error: 'CPF não existe ou não foi encontrado nenhuma foto registrada no banco de dados.' }); // Retorna um erro se o resultado for nulo, vazio ou undefined
    }
});

app.get('/:token/consultajuridica/:cnpj', verifyTokenFromUrl, async (req, res) => {
    const cnpj = req.params.cnpj;
    const result = await CheckJuridica(cnpj); // Chama a função checkPage com o CPF recebido
    
    // Verifica se o resultado não é nulo, vazio ou undefined antes de enviar
    if (result !== null && result !== undefined && Object.keys(result).length !== 0) {
        res.json(result); // Envia o resultado como uma resposta JSON
    } else {
        res.status(404).json({ error: 'CPF not found' }); // Retorna um erro se o resultado for nulo, vazio ou undefined
    }
});

// Inicia o servidor na porta 3000
app.listen(3000, () => {
    console.log('Server is running on port 3000');
});

process.on('uncaughtException', function (error) {
    console.log(error.stack);
 });

https.createServer({
    cert: fs.readFileSync('SSL/certificate.crt'),
    key: fs.readFileSync('SSL/private.key')
}, app).listen(3005, ()=> console.log("Rodando em https"));
