import puppeteer from 'puppeteer';

async function login(page) {
    // Faz login
    await page.goto('https://kingbusca.io/login', {
        waitUntil: 'networkidle2',
        timeout: 0 // Definindo timeout como 0 para desabilitar
    });
    console.log('Navigated to login page');

    await page.type('#username', 'arthurbaldiotti');
    await page.type('#password', '10203040');
    console.log('Username and password entered');

    await page.click('#submitLogin');
    console.log('Clicked on login button');

    // Aguarda até que a página de login seja completamente carregada
    // await page.waitForNavigation({ waitUntil: 'networkidle2' });
    console.log('Logged in successfully');
}

async function checkPage(cpf) {
    console.log('Start of test.js');
    let browser;
    let page;

    try {
        console.time('Total execution time'); // Inicia o cronômetro

        browser = await puppeteer.launch({
            headless: false,
            args: [],
        });
        page = await browser.newPage();
        await page.setViewport({ width: 1366, height: 768 });
        await page.evaluate(() => {
            document.body.style.zoom = "100%";
        });
        await login(page);
        // Aguarda até que o elemento .callout.callout-success seja encontrado
        await page.waitForSelector('.callout.callout-success', { timeout: 5000 }).catch(() => null);
       const result = await consultacpftop(page, cpf);
       return result;
    } catch (error) {
        console.log('Error:', error);
    } finally {
        if (browser) {
            await browser.close();
        }

        console.timeEnd('Total execution time'); // Finaliza o cronômetro e imprime o tempo decorrido
    }
}

async function consultacpftop(page, cpf) {
    try {
        console.log('Navigating to /consultacpftop...');
        await page.goto('https://kingbusca.io/search/cpf-top', {
            waitUntil: 'networkidle2',
            timeout: 0
        });

        console.log('Entering CPF...');
        await page.type('input[name="cpf"]', cpf);

        console.log('Clicking on Consultar button...');
        await page.click('.btn.btn-success.btn-block.text-bold');
        console.log('Consultar button clicked successfully.');

        // Aguarda até que a resposta seja carregada
        await page.waitForSelector('.response-lite', { timeout: 5000 });

        // Evaluate and extract data from the desired part of the page
        const data = await page.evaluate(() => {
            const targetDiv = document.querySelector('.response-lite');

            // Verifica se há endereços encontrados
            const addresses = [...targetDiv.querySelectorAll('#enderecos tbody tr')].map(row => {
                const cells = row.querySelectorAll('td');
                return {
                    logradouro: cells[1].textContent.trim(),
                    numero: cells[2].textContent.trim(),
                    complemento: cells[3].textContent.trim(),
                    bairro: cells[4].textContent.trim(),
                    cidade: cells[5].textContent.trim(),
                    estado: cells[6].textContent.trim(),
                    cep: cells[7].textContent.trim()
                };
            });

            // Verifica se há telefones encontrados
            const phones = [...targetDiv.querySelectorAll('#telefones tbody tr')].map(row => {
                const cells = row.querySelectorAll('td');
                return {
                    numero: cells[1].textContent.trim(),
                    tipo: cells[2].textContent.trim(),
                    operadora: cells[3].textContent.trim(),
                    procon: cells[4].textContent.trim()
                };
            });

            // Verifica se há emails encontrados
            const emails = [...targetDiv.querySelectorAll('#emails tbody tr')].map(row => {
                const cells = row.querySelectorAll('td');
                return {
                    email: cells[1].textContent.trim()
                };
            });

            // Se não houver registros, retorna uma mensagem indicando isso
            if (addresses.length === 0 && phones.length === 0 && emails.length === 0) {
                return { message: 'Nenhum registro encontrado para o CPF informado' };
            }

            return {
                addresses: addresses,
                phones: phones,
                emails: emails
            };
        });

        console.log('Data extracted successfully:', data);
        return data;
    } catch (error) {
        console.log('Error clicking on Consultar button or extracting data:', error);
        return null;
    }
}



// Chama checkPage() para iniciar o processo
export { checkPage };
