import puppeteer from 'puppeteer';
import fs from 'fs';
import path from 'path';
import PDFDocument from 'pdfkit';
import { promisify } from 'util';
import { default as sizeOfCallback } from 'image-size';

const sizeOf = promisify(sizeOfCallback);

// Função para formatar o CPF
function formatCPF(cpf) {
    // Remove todos os caracteres não numéricos
    cpf = cpf.replace(/\D/g, '');

    // Aplica a formatação do CPF (###.###.###-##)
    return cpf.replace(/(\d{3})(\d{3})(\d{3})(\d{2})/, '$1.$2.$3-$4');
}

async function convertToPDF(jpegFilePath, pdfFilePath, width, height) {
    return new Promise(async (resolve, reject) => {
        try {
            // Cria um novo documento PDF com base nas dimensões da imagem
            const doc = new PDFDocument({ size: [width, height] });

            // Cria um stream de escrita para o arquivo PDF
            const writeStream = fs.createWriteStream(pdfFilePath);

            // Redireciona a saída do PDF para o stream de escrita
            doc.pipe(writeStream);

            // Centraliza a imagem horizontalmente no PDF
            const offsetX = (doc.page.width - width) / 2;
            doc.image(jpegFilePath, offsetX, 0, { width: width, height: height });

            // Fecha o documento PDF
            doc.end();

            // Lidar com eventos de conclusão e erro
            writeStream.on('finish', () => {
                console.log(`Arquivo PDF criado em: ${pdfFilePath}`);
                resolve(pdfFilePath);
            });

            writeStream.on('error', err => {
                reject(err);
            });
        } catch (error) {
            reject(error);
        }
    });
}

async function solveImageCaptcha(page) {
    try {
        // Insere a resposta no campo de entrada do captcha
        await page.evaluate(() => {
            // Envie uma mensagem para a extensão CapSolver para resolver o captcha
            window.postMessage({
                type: 'CAPTCHA_TASK',
                task: {
                    type: 'CAPTCHA_RECOGNITION',
                    payload: {
                        siteKey: '6LfSGrgpAAAAAPgEkTBPTSEi2VYcZkIkFLKoNVkK', // Substitua pelo site key do captcha
                        websiteURL: 'https://app.Buscasix.online/', // Substitua pela URL onde o captcha está localizado
                    }
                }
            }, '*');
        });

        console.log('Image captcha solved.');
    } catch (error) {
        console.error('Error solving image captcha:', error);
    }
}

async function login(page) {
    // Faz login
    await page.goto('https://app.Buscasix.online/dividas/', {
        waitUntil: 'networkidle2',
        timeout: 0 // Definindo timeout como 0 para desabilitar
    });
    console.log('Navigated to login page');

    await page.type('#login', 'arthurbaldiotti');
    await page.type('#senha', 'arthur1234');
    console.log('Username and password entered');

    // Solucionar o captcha de imagem
    await solveImageCaptcha(page);
    console.log('Captcha solved.');

    // Aguarda até que a página de login seja completamente carregada
    console.log('Logged in successfully');
}

async function ConsultaSix(page, cpf) {
    try {
        console.log('Opening new tab for BuscaSix2/Dividas...');

        console.log('Entering CPF...');
        await page.waitForSelector('input[name="cpf"]', { timeout: 60000 });
        
        // Formatar o CPF para o formato correto
        const formattedCPF = formatCPF(cpf);
        await page.type('input[name="cpf"]', formattedCPF);

        console.log('Clicking on Consultar button...');
        await page.click('.btn.btn-sm.btn-success');
        console.log('Consultar button clicked successfully.');

        // Aguarda até que o botão de imagem seja visível
        await page.waitForSelector('a.btn.btn-sm.btn-primary[data-toggle="tooltip"][title="Clique aqui para gerar uma imagem do relatório"]', { timeout: 60000 });

        // Execute o clique no botão de imagem usando o evaluate
        await page.evaluate(() => {
            const imagemButton = document.querySelector('a.btn.btn-sm.btn-primary[data-toggle="tooltip"][title="Clique aqui para gerar uma imagem do relatório"]');
            imagemButton.click();
        });

        console.log('IMAGEM button clicked successfully.');

        // Aguarda um tempo suficiente para o download ser concluído (vamos considerar 10 segundos)
        await page.waitForTimeout(5000);

        const downloadPath = 'C:/Users/Administrator/Downloads'; // Substitua pelo caminho correto da pasta de downloads
        const jpegFileName = `BuscaSix2-Dívidas - SCPC + Serasa-${cpf.replace(/[^\d]/g, '')}.jpeg`; // Remove caracteres não numéricos do CPF
        const jpegFilePath = path.join(downloadPath, jpegFileName);

        // Verifica se o arquivo JPEG foi baixado corretamente
        if (!fs.existsSync(jpegFilePath)) {
            throw new Error(`JPEG file not found at: ${jpegFilePath}`);
        }

        const pdfFileName = `Consultas-${cpf.replace(/[^\d]/g, '')}.pdf`; // Remove caracteres não numéricos do CPF
        const pdfFilePath = path.join(downloadPath, pdfFileName);

        // Obtém as dimensões da imagem JPEG
        const { width, height } = await sizeOf(jpegFilePath);

        // Converte o arquivo JPEG baixado para PDF
        await convertToPDF(jpegFilePath, pdfFilePath, width, height);

        console.log(`Arquivo JPEG convertido para PDF: ${pdfFilePath}`);

        // Move o arquivo PDF para outra pasta
        const targetPath = 'C:/xampp/htdocs/buscas'; // Substitua pelo caminho da pasta de destino
        const newPdfFilePath = path.join(targetPath, pdfFileName);
        fs.renameSync(pdfFilePath, newPdfFilePath);
        console.log(`Arquivo PDF movido para: ${newPdfFilePath}`);

        // Retorna o nome do arquivo PDF criado
        const resultado = `http://104.234.224.187/buscas/${pdfFileName}`
        return resultado;
    } catch (error) {
        console.log('Error clicking on Consultar button or extracting data:', error);

        return null;
    }
}

async function BuscaSix2(cpf) {
    console.log('Start of test.js');
    let browser;

    try {
        console.time('Total execution time'); // Inicia o cronômetro
        browser = await puppeteer.launch({
            headless: false,
            args: [
                `--disable-extensions-except=${path.resolve('./CapSolver-Extension')}`,
                `--load-extension=${path.resolve('./CapSolver-Extension')}`,
                '--allow-http-screen-capture',
                '--allow-file-access-from-files',
                '--allow-file-access',
                '--allow-cross-origin-auth-prompt',
                '--allow-clipboard-read',
                '--allow-silent-push',
                '--disable-web-security'
            ],
        });

        const page = await browser.newPage();
        await page.setViewport({ width: 1366, height: 768 });
        await page.evaluate(() => {
            document.body.style.zoom = "100%";
        });

        // Chama a função de login
        await login(page);
        const result = await ConsultaSix(page, cpf);
        console.log(result);
        return JSON.stringify({result});
    } catch (error) {
        console.log('Error:', error);
        await browser.close();
        return null;
    } finally {
        if (browser) {
            await browser.close();
        }

        console.timeEnd('Total execution time'); // Finaliza o cronômetro e imprime o tempo decorrido
    }
}

// Chama BuscaSix2() para iniciar o processo
export { BuscaSix2 };
