import puppeteer from 'puppeteer';

async function login(page) {
    // Faz login
    await page.goto('https://kingbusca.io/login', {
        waitUntil: 'networkidle2',
        timeout: 0 // Definindo timeout como 0 para desabilitar
    });
    console.log('Navigated to login page');

    await page.type('#username', 'arthurbaldiotti');
    await page.type('#password', '10203040');
    console.log('Username and password entered');

    await page.click('#submitLogin');
    console.log('Clicked on login button');

    // Aguarda até que a página de login seja completamente carregada
    // await page.waitForNavigation({ waitUntil: 'networkidle2' });
    console.log('Logged in successfully');
}

async function CheckJuridica(cnpj) {
    console.log('Start of test.js');
    let browser;
    let page;

    try {
        console.time('Total execution time'); // Inicia o cronômetro

        browser = await puppeteer.launch({
            headless: 'auto',
            args: [],
        });
        page = await browser.newPage();
        await page.setViewport({ width: 1366, height: 768 });
        await page.evaluate(() => {
            document.body.style.zoom = "100%";
        });
        await login(page);
        // Aguarda até que o elemento .callout.callout-success seja encontrado
        await page.waitForSelector('.callout.callout-success', { timeout: 5000 }).catch(() => null);
        const result = await consultajuridica(page, cnpj);
        return result;
    } catch (error) {
        console.log('Error:', error);
    } finally {
        if (browser) {
            await browser.close();
        }

        console.timeEnd('Total execution time'); // Finaliza o cronômetro e imprime o tempo decorrido
    }
}

async function consultajuridica(page, cnpj) {
    try {
        console.log('Navigating to search/pessoa-juridica...');
        await page.goto('https://kingbusca.io/search/pessoa-juridica', {
            waitUntil: 'networkidle2',
            timeout: 0
        });

        console.log('Entering CNPJ...');
        await page.type('input[name="cnpj"]', cnpj);

        console.log('Clicking on Consultar button...');
        await page.click('.btn.btn-success.btn-block.text-bold');
        console.log('Consultar button clicked successfully.');

        // Aguarda até que a resposta seja carregada
        await page.waitForSelector('.response-lite', { timeout: 60000 });
        const data = await page.evaluate(() => {
            const targetDiv = document.querySelector('.response-lite');
        
            // Extrai os dados cadastrais
            const dadosCadastrais = {};
            const rows = targetDiv.querySelectorAll('.table-hover tbody tr');
            for (const row of rows) {
                const th = row.querySelector('th');
                const td = row.querySelector('td');
                if (th && td) {
                    dadosCadastrais[th.textContent.trim()] = td.textContent.trim();
                }
            }
        
  // Extrai os endereços
  const enderecos = [];
  const h4Elements = targetDiv.querySelectorAll('h4');
  for (const h4Element of h4Elements) {
      if (h4Element.textContent.includes('ENDEREÇO')) {
          let currentElement = h4Element.nextElementSibling;
          while (currentElement && currentElement.tagName.toLowerCase() !== 'h4') {
              if (currentElement.tagName.toLowerCase() === 'table') {
                  const enderecoRows = currentElement.querySelectorAll('tbody tr');
                  enderecoRows.forEach(row => {
                      const cells = row.querySelectorAll('td');
                      const endereco = {
                          tipoLogradouro: cells[0].textContent.trim(),
                          logradouro: cells[1].textContent.trim(),
                          numero: cells[2].textContent.trim(),
                          bairro: cells[3].textContent.trim(),
                          cidade: cells[4].textContent.trim(),
                          uf: cells[5].textContent.trim(),
                          cep: cells[6].textContent.trim(),
                          latitude: cells[7].textContent.trim(),
                          longitude: cells[8].textContent.trim(),
                          regiao: cells[9].textContent.trim()
                      };
                      enderecos.push(endereco);
                  });
              }
              currentElement = currentElement.nextElementSibling;
          }
          break; // Termina o loop depois de encontrar a seção de endereço
      }
  }
    // Extrai os telefones
    const telefones = [];
    const h4Elements2 = targetDiv.querySelectorAll('h4');
    for (const h4Element of h4Elements2) {
        if (h4Element.textContent.includes('TELEFONE')) {
            let currentElement = h4Elements2.nextElementSibling;
            while (currentElement && currentElement.tagName.toLowerCase() !== 'h4') {
                if (currentElement.tagName.toLowerCase() === 'table') {
                    const telefoneRows = currentElement.querySelectorAll('tbody tr');
                    telefoneRows.forEach(row => {
                        const cells = row.querySelectorAll('td');
                        const telefone = {
                            ddd: cells[0].textContent.trim(),
                            numero: cells[1].textContent.trim(),
                            tipo: cells[2].textContent.trim(),
                            operadora: cells[3].textContent.trim()
                        };
                        telefones.push(telefone);
                    });
                }
                currentElement = currentElement.nextElementSibling;
            }
            break; // Termina o loop depois de encontrar a seção de telefone
        }
    }
        
    const emails = [];
    const h4Elements3 = targetDiv.querySelectorAll('h4');
    for (const h4Element of h4Elements3) {
        if (h4Element.textContent.includes('EMAIL')) {
            let currentElement = h4Elements3.nextElementSibling;
            while (currentElement && currentElement.tagName.toLowerCase() !== 'h4') {
                if (currentElement.tagName.toLowerCase() === 'table') {
                    const emailRows = currentElement.querySelectorAll('tbody tr');
                    emailRows.forEach(row => {
                        const cells = row.querySelectorAll('td');
                        const email = {
                            email: cells[0].textContent.trim()
                        };
                        emails.push(email);
                    });
                }
                currentElement = currentElement.nextElementSibling;
            }
            break; // Termina o loop depois de encontrar a seção de email
        }
    }
        
            return {
                dadosCadastrais: dadosCadastrais,
                enderecos: enderecos,
                telefones: telefones,
                emails: emails
            };
        });
        
        console.log('Data extracted successfully:', data);
        return data;
        

    } catch (error) {
        console.log('Error clicking on Consultar button or extracting data:', error);
        return null;
    }
}


// Chama checkPage() para iniciar o processo
export { CheckJuridica };
