import puppeteer from 'puppeteer';

async function login(page) {
    // Faz login
    await page.goto('https://maxbuscas.info/Login', {
        waitUntil: 'networkidle2',
        timeout: 0 // Definindo timeout como 0 para desabilitar
    });
    console.log('Navigated to login page');

    await page.type('#email', 'arthurbaldiotti@hotmail.com');
    await page.type('#Senha', 'Arthur@1234');
    console.log('Username and password entered');
    await page.waitForSelector('.captcha-solver')
    await page.click('.captcha-solver')
    await page.waitForSelector(`.captcha-solver[data-state="solved"]`, {timeout: 180000})

    await page.click('#buttonlogin');
    console.log('Clicked on login button');

    // Aguarda até que a página de login seja completamente carregada
    // await page.waitForNavigation({ waitUntil: 'networkidle2' });
    console.log('Logged in successfully');
}

async function BuscaSix() {
    console.log('Start of test.js');
    let browser;
    let page;

    try {
        console.time('Total execution time'); // Inicia o cronômetro

        browser = await puppeteer.launch({
            headless: false,
            args: [],
        });
        page = await browser.newPage();
        await page.setViewport({ width: 1366, height: 768 });
        await page.evaluate(() => {
            document.body.style.zoom = "100%";
        });
        await login(page);
        // Aguarda até que o elemento .callout.callout-success seja encontrado
        // await page.waitForSelector('.btn btn-sm btn-primary', { timeout: 5000 }).catch(() => null);
        // const result = await ConsultaSix(page);
        return result;
    } catch (error) {
        console.log('Error:', error);
    } finally {
        if (browser) {
            // await browser.close();
        }

        console.timeEnd('Total execution time'); // Finaliza o cronômetro e imprime o tempo decorrido
    }
}

async function ConsultaSix(page) {
    try {
        console.log('Navigating to BuscaSix/Dividas...');
        await page.goto('https://app.buscasix.online/dividas/', {
            waitUntil: 'networkidle2',
            timeout: 0
        });

        console.log('Entering CPF...');
        await page.type('input[name="cpf"]', '326.762.778-80');

        console.log('Clicking on Consultar button...');
        await page.click('.btn.btn-sm.btn-success');
        console.log('Consultar button clicked successfully.');

         // Aguarda até que a resposta seja carregada
        await page.waitForSelector('.modal-content', { timeout: 60000 });
        const data = await page.evaluate(() => {
            const targetDivs = document.querySelectorAll('.block');
        
            // Certifique-se de que há pelo menos duas divs com a classe 'block'
            // if (targetDivs.length < 2) {
            //     return { error: 'Less than two div blocks found' };
            // }
        
            // Seleciona a segunda div com a classe 'block'
            const targetDiv = targetDivs[1];
        
            // Extrai os dados cadastrais
            const dadosCadastrais = {};
            const rows = targetDiv.querySelectorAll('.table-hover tbody tr');
        
            rows.forEach(row => {
                const tds = row.querySelectorAll('td');
                if (tds.length >= 2) {
                    const label = tds[0].textContent.replace(/:/g, '').trim();
                    const value = tds[1].textContent.trim();
                    dadosCadastrais[label] = value;
                }
            });
        
            // Verifica se algum dado foi extraído
            if (Object.keys(dadosCadastrais).length === 0) {
                return { error: 'No data extracted' };
            }
        
            // Retorna os dados extraídos
            return {
                dadosCadastrais: dadosCadastrais
            };
        });
        
        console.log('Data extracted successfully:', data);
        return data;
        
        
        
        

    } catch (error) {
        console.log('Error clicking on Consultar button or extracting data:', error);
        return null;
    }
}


// Chama checkPage() para iniciar o processo
BuscaSix()
