import puppeteer from 'puppeteer';

async function login(page) {
    // Faz login
    await page.goto('https://kingbusca.io/login', {
        waitUntil: 'networkidle2',
        timeout: 0 // Definindo timeout como 0 para desabilitar
    });
    console.log('Navigated to login page');

    await page.type('#username', 'arthurbaldiotti');
    await page.type('#password', '10203040');
    console.log('Username and password entered');

    await page.click('#submitLogin');
    console.log('Clicked on login button');

    // Aguarda até que a página de login seja completamente carregada
    // await page.waitForNavigation({ waitUntil: 'networkidle2' });
    console.log('Logged in successfully');
}

async function checkScore(cpf) {
    console.log('Start of test.js');
    let browser;
    let page;

    try {
        console.time('Total execution time'); // Inicia o cronômetro

        browser = await puppeteer.launch({
            headless: 'auto',
            args: [],
        });
        page = await browser.newPage();
        await page.setViewport({ width: 1366, height: 768 });
        await page.evaluate(() => {
            document.body.style.zoom = "100%";
        });
        await login(page);
        // Aguarda até que o elemento .callout.callout-success seja encontrado
        await page.waitForSelector('.callout.callout-success', { timeout: 5000 }).catch(() => null);
        const result = await consultacpftop(page, cpf);
        return result;
    } catch (error) {
        console.log('Error:', error);
    } finally {
        if (browser) {
            await browser.close();
        }

        console.timeEnd('Total execution time'); // Finaliza o cronômetro e imprime o tempo decorrido
    }
}

async function consultacpftop(page, cpf) {
    try {
        console.log('Navigating to /search/score...');
        await page.goto('https://kingbusca.io/search/score', {
            waitUntil: 'networkidle2',
            timeout: 0
        });

        console.log('Entering CPF...');
        await page.type('input[name="cpf"]', cpf);

        console.log('Clicking on Consultar button...');
        await page.click('.btn.btn-success.btn-block.text-bold');
        console.log('Consultar button clicked successfully.');

        // Aguarda até que a resposta seja carregada
        await page.waitForSelector('.response-lite', { timeout: 60000 });
        const scores = await page.evaluate(() => {
            const targetDiv = document.querySelector('.response-lite');

            // Seleciona todos os elementos com a classe .scoreValue
            const scoreElements = targetDiv.querySelectorAll('.box-body .scoreValue');

            // Extrai os valores do Score Positivo e do Score SPC
            let scorePositivo = null;
            let scoreSPC = null;

            if (scoreElements.length >= 1) {
                scorePositivo = scoreElements[0].textContent.trim();
            }

            if (scoreElements.length >= 2) {
                scoreSPC = scoreElements[1].textContent.trim();
            }

            return {
                scorePositivo: scorePositivo,
                scoreSPC: scoreSPC
            };
        });

        console.log('Scores extracted successfully:', scores);
        return scores;


    } catch (error) {
        console.log('Error clicking on Consultar button or extracting data:', error);
        return null;
    }
}


// Chama checkPage() para iniciar o processo
export { checkScore };
