import puppeteer from 'puppeteer';
import { timeout } from 'puppeteer';

async function login(page) {
    // Faz login
    await page.goto('https://newbuscas.tech/Login', {
        waitUntil: 'networkidle2',
        timeout: 0 // Definindo timeout como 0 para desabilitar
    });
    console.log('Navigated to login page');

    await page.type('#username', 'arthurbaldiotti');
    await page.type('#password-input', '10203040');
    console.log('Username and password entered');

    await page.click('.btn-success');
    console.log('Clicked on login button');

    // Aguarda até que a página de login seja completamente carregada
    // await page.waitForNavigation({ waitUntil: 'networkidle2' });
    console.log('Logged in successfully');
}

async function checkPage() {
    console.log('Start of test.js');
    let browser;
    let page;

    try {
        console.time('Total execution time'); // Inicia o cronômetro

        browser = await puppeteer.launch({
            headless: false,
            args: [],
        });
        page = await browser.newPage();
        await page.setViewport({ width: 1366, height: 768 });
        await page.evaluate(() => {
            document.body.style.zoom = "100%";
        });
        await login(page);
        // Aguarda até que o elemento .callout.callout-success seja encontrado
        await page.waitForSelector('.callout.callout-success', { timeout: 5000 }).catch(() => null);
       const result = await CPFTracker(page);
       return result;
    } catch (error) {
        console.log('Error:', error);
    } finally {
        if (browser) {
            // await browser.close();
        }

        console.timeEnd('Total execution time'); // Finaliza o cronômetro e imprime o tempo decorrido
    }
}

async function CPFTracker(page) {
    try {
        // Aguarda até que a imagem seja visível na página
        await page.waitForSelector('img.zoom-image[src="assets/img/big-data.png"]');

        // Localiza a imagem
        const image = await page.$('img.zoom-image[src="assets/img/big-data.png"]');

        // Clica na imagem
        await image.click();

        // Aguarda até que o campo de CPF seja visível na página
        await page.waitForSelector('input[name="num"]');

        // Função para filtrar apenas números
        const filtrarSomenteNumeros = (input) => {
            const value = input.value;
            input.value = value.replace(/\D/g, '');
        };

        const cpf = '32676277880'
        // Inserir CPF no campo (exemplo)
        await page.$eval('input[name="num"]', (element, cpf) => {
            element.value = cpf;
        }, cpf);

        // Aguarda até que o botão de consultar seja visível na página
        await page.waitForSelector('button.btn.btn-primary');

        // Localiza o botão de consultar
        const consultarButton = await page.$('button.btn.btn-primary');

        // Clica no botão de consultar
        await consultarButton.click();
        
        // Aguarda até que a tabela "Score" seja visível na página
        await page.waitForSelector('table-striped table-hover');

        const data = await page.evaluate(() => {
            const extractTableData = (tableId) => {
                const table = document.querySelector(tableId);
                if (!table) return {}; 
        
                const rows = table.querySelectorAll('tbody tr');
                const tableData = {};
                rows.forEach((row, index) => {
                    const cells = row.querySelectorAll('td');
                    const key = cells[0].textContent.trim();
                    const value = cells[1].textContent.trim();
                    tableData[key] = value;
                });
                return tableData;
            };
        
            const basicInfoTable = extractTableData('.table-striped');
            const formattedData = {
                basicInfo: basicInfoTable,
            };
        
            return formattedData;
        });
        
        console.log('Data extracted successfully:', data);
        return data;
        

    } catch (error) {
        console.log('Error clicking on Consultar button or extracting data:', error);
        return null;
    }
}



// Chama checkPage() para iniciar o processo
// export { checkPage };
checkPage();
